/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class MessageExplosion
implements IMessage {
    public ExplosionType type;
    public float size;
    public double posX;
    public double posY;
    public double posZ;
    public byte[][] affectedBlocks;

    public MessageExplosion() {
    }

    public MessageExplosion(Explosion explosion) {
        this.type = explosion.field_82755_b ? ExplosionType.NORMAL : ExplosionType.SAFE;
        this.size = explosion.field_77280_f;
        this.posX = (float)explosion.field_77284_b;
        this.posY = (float)explosion.field_77285_c;
        this.posZ = (float)explosion.field_77282_d;
        if (this.type == ExplosionType.NORMAL) {
            int count = explosion.field_77281_g.size();
            this.affectedBlocks = new byte[count][];
            int blockX = (int)Math.floor(this.posX);
            int blockY = (int)Math.floor(this.posY);
            int blockZ = (int)Math.floor(this.posZ);
            for (int i = 0; i < count; ++i) {
                ChunkPosition pos = (ChunkPosition)explosion.field_77281_g.get(i);
                this.affectedBlocks[i] = new byte[]{(byte)(pos.field_151329_a - blockX), (byte)(pos.field_151327_b - blockY), (byte)(pos.field_151328_c - blockZ)};
            }
        }
    }

    public MessageExplosion(Entity exploder, float size, String type) {
        this(exploder.field_70165_t, exploder.field_70163_u, exploder.field_70161_v, size, type);
    }

    public MessageExplosion(double posX, double posY, double posZ, float size, String type) {
        if ("lightning".equalsIgnoreCase(type)) {
            this.type = ExplosionType.LIGHTNING;
        }
        this.size = size;
        this.posX = (float)posX;
        this.posY = (float)posY;
        this.posZ = (float)posZ;
    }

    public void fromBytes(ByteBuf buf) {
        int count = 0;
        try {
            this.type = ExplosionType.getType(buf.readByte());
            this.size = buf.readFloat();
            this.posX = buf.readDouble();
            this.posY = buf.readDouble();
            this.posZ = buf.readDouble();
            if (this.type == ExplosionType.NORMAL) {
                count = buf.readInt();
                this.affectedBlocks = new byte[count][];
                for (int i = 0; i < count; ++i) {
                    this.affectedBlocks[i] = new byte[]{buf.readByte(), buf.readByte(), buf.readByte()};
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            buf.writeByte((int)this.type.getId());
            buf.writeFloat(this.size);
            buf.writeDouble(this.posX);
            buf.writeDouble(this.posY);
            buf.writeDouble(this.posZ);
            if (this.type == ExplosionType.NORMAL) {
                int count = this.affectedBlocks.length;
                buf.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    for (int d = 0; d < 3; ++d) {
                        buf.writeByte((int)this.affectedBlocks[i][d]);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Handler
    implements IMessageHandler<MessageExplosion, IMessage> {
        public IMessage onMessage(MessageExplosion message, MessageContext ctx) {
            try {
                WorldClient world = FMLClientHandler.instance().getWorldClient();
                if (message.type == ExplosionType.LIGHTNING) {
                    if (message.size < 0.0f) {
                        message.size = 0.0f;
                    }
                    for (float x = -message.size; x <= message.size; x += 1.0f) {
                        for (float z = -message.size; z <= message.size; z += 1.0f) {
                            world.func_72838_d((Entity)new EntityLightningBolt((World)world, message.posX + (double)x, message.posY, message.posZ + (double)z));
                        }
                    }
                } else {
                    if (message.type == ExplosionType.NORMAL && message.size >= 2.0f) {
                        world.func_72869_a("hugeexplosion", message.posX, message.posY, message.posZ, 1.0, 0.0, 0.0);
                    } else {
                        world.func_72869_a("largeexplode", message.posX, message.posY, message.posZ, 1.0, 0.0, 0.0);
                    }
                    if (message.type == ExplosionType.NORMAL && message.affectedBlocks != null) {
                        int count = message.affectedBlocks.length;
                        for (int i = 0; i < count; ++i) {
                            double[] relPos = new double[3];
                            for (int d = 0; d < 3; ++d) {
                                relPos[d] = (float)message.affectedBlocks[i][d] + world.field_73012_v.nextFloat();
                            }
                            double fxPosX = relPos[0] + message.posX;
                            double fxPosY = relPos[1] + message.posY;
                            double fxPosZ = relPos[2] + message.posZ;
                            double velo = Math.sqrt(relPos[0] * relPos[0] + relPos[1] * relPos[1] + relPos[2] * relPos[2]);
                            double mult = 0.5 / (velo / (double)message.size + 0.1) * (double)(world.field_73012_v.nextFloat() * world.field_73012_v.nextFloat() + 0.3f) / velo;
                            int d = 0;
                            while (d < 3) {
                                int n = d++;
                                relPos[n] = relPos[n] * mult;
                            }
                            world.func_72869_a("explode", (fxPosX + message.posX) / 2.0, (fxPosY + message.posY) / 2.0, (fxPosZ + message.posZ) / 2.0, relPos[0], relPos[1], relPos[2]);
                            world.func_72869_a("smoke", fxPosX, fxPosY, fxPosZ, relPos[0], relPos[1], relPos[2]);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static enum ExplosionType {
        SAFE(0),
        NORMAL(1),
        LIGHTNING(2);

        private static final ExplosionType[] allTypes;
        private final byte TYPE_ID;

        private ExplosionType(int id) {
            this.TYPE_ID = (byte)id;
        }

        public byte getId() {
            return this.TYPE_ID;
        }

        public static ExplosionType getType(byte id) {
            return allTypes[id % allTypes.length];
        }

        static {
            allTypes = new ExplosionType[ExplosionType.values().length];
            ExplosionType[] types = ExplosionType.values();
            int length = types.length;
            for (int i = 0; i < length; ++i) {
                ExplosionType type;
                ExplosionType.allTypes[type.getId()] = type = types[i];
            }
        }
    }
}

