/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.EntityLavaMonster;

public class SpawnLavaMonster {
    public static final int SPAWN_FREQUENCY = Properties.getInt("lavamonster_spawning", "lavamonster_spawn_frequency");
    public static final int SPAWN_MAX = Properties.getInt("lavamonster_spawning", "lavamonster_spawn_max");
    public static final int SPAWN_RANGE = Properties.getInt("lavamonster_spawning", "lavamonster_spawn_range");
    public static final double SPAWN_CHANCE = Properties.getDouble("lavamonster_spawning", "lavamonster_spawn_chance");
    public static final boolean DEPTH_HAZARD = Properties.getBoolean("lavamonster_spawning", "lavamonster_depth_hazard");
    public static final boolean SHALLOW_LAVA = Properties.getBoolean("lavamonster_spawning", "lavamonster_shallow_lava");
    public static final boolean FLOWING_LAVA = Properties.getBoolean("lavamonster_spawning", "lavamonster_flowing_lava");
    public static final boolean NETHER_SPAWN = Properties.getBoolean("lavamonster_spawning", "lavamonster_Nether_spawn");
    private int spawnTime = 0;
    private HashMap<ChunkCoordIntPair, Boolean> eligibleChunksForSpawning = new HashMap();

    public SpawnLavaMonster() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static boolean canLavaMonsterSpawnAtLocation(World world, int x, int y, int z) {
        return !(DEPTH_HAZARD && y > 16 && !world.field_73011_w.field_76575_d || world.func_147439_a(x, y, z).func_149688_o() != Material.field_151587_i || world.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151587_i && (!SHALLOW_LAVA || world.func_147445_c(x, y + 1, z, true)) || !FLOWING_LAVA && world.func_72805_g(x, y, z) != 0 && world.func_72805_g(x, y + 1, z) != 0);
    }

    private int performSpawning(WorldServer world) {
        if (world.field_73010_i.size() == 0) {
            return 0;
        }
        if (!NETHER_SPAWN && world.field_73011_w.field_76575_d || ++this.spawnTime < SPAWN_FREQUENCY) {
            return 0;
        }
        this.spawnTime = 0;
        this.eligibleChunksForSpawning.clear();
        for (EntityPlayer player : world.field_73010_i) {
            int chunkX = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0));
            int chunkZ = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0));
            int spawnRange = SPAWN_RANGE & 0xFF;
            for (int x = -spawnRange; x <= spawnRange; ++x) {
                for (int z = -spawnRange; z <= spawnRange; ++z) {
                    boolean isEdge = x == -spawnRange || x == spawnRange || z == -spawnRange || z == spawnRange;
                    ChunkCoordIntPair chunkCoord = new ChunkCoordIntPair(x + chunkX, z + chunkZ);
                    if (!isEdge) {
                        this.eligibleChunksForSpawning.put(chunkCoord, false);
                        continue;
                    }
                    if (this.eligibleChunksForSpawning.containsKey(chunkCoord)) continue;
                    this.eligibleChunksForSpawning.put(chunkCoord, true);
                }
            }
        }
        int numberSpawned = 0;
        ChunkCoordinates spawnCoords = world.func_72861_E();
        int adjustTotalChunks = (SPAWN_RANGE * 2 + 1) * (SPAWN_RANGE * 2 + 1);
        int countInWorld = world.func_72907_a(EntityLavaMonster.class);
        int maxAllowedInWorld = SPAWN_MAX * this.eligibleChunksForSpawning.size() / adjustTotalChunks;
        _SpecialMobs.debugConsole("Lava monster count " + countInWorld + "  Max allowed " + maxAllowedInWorld);
        if (countInWorld < maxAllowedInWorld) {
            ArrayList<ChunkCoordIntPair> chunks = new ArrayList<ChunkCoordIntPair>(this.eligibleChunksForSpawning.keySet());
            Collections.shuffle(chunks);
            block3: for (ChunkCoordIntPair chunkCoord : chunks) {
                if (numberSpawned >= maxAllowedInWorld - countInWorld) break;
                if (this.eligibleChunksForSpawning.get(chunkCoord).booleanValue()) continue;
                ChunkPosition chunkPos = this.getRandomSpawningPointInChunk((World)world, chunkCoord.field_77276_a, chunkCoord.field_77275_b);
                int x = chunkPos.field_151329_a;
                int y = chunkPos.field_151327_b;
                int z = chunkPos.field_151328_c;
                if (SPAWN_CHANCE * 100.0 < (double)world.field_73012_v.nextInt(100) || world.func_147445_c(x, y, z, true)) continue;
                int groupRadius = 6;
                int groupSpawnAttempt = 3;
                while (groupSpawnAttempt-- > 0) {
                    int X = x;
                    int Y = y;
                    int Z = z;
                    int spawnAttempt = 4;
                    while (spawnAttempt-- > 0) {
                        float spawnZ;
                        float spawnY;
                        float spawnX;
                        float spawnDist;
                        float posZ;
                        float posY;
                        float posX;
                        if (!SpawnLavaMonster.canLavaMonsterSpawnAtLocation((World)world, X += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius), Y += world.field_73012_v.nextInt(1) - world.field_73012_v.nextInt(1), Z += world.field_73012_v.nextInt(groupRadius) - world.field_73012_v.nextInt(groupRadius)) || world.func_72977_a((double)(posX = (float)X + 0.5f), (double)(posY = (float)Y), (double)(posZ = (float)Z + 0.5f), 24.0) != null || !((spawnDist = (spawnX = posX - (float)spawnCoords.field_71574_a) * spawnX + (spawnY = posY - (float)spawnCoords.field_71572_b) * spawnY + (spawnZ = posZ - (float)spawnCoords.field_71573_c) * spawnZ) >= 576.0f)) continue;
                        EntityLavaMonster lavaMonster = new EntityLavaMonster((World)world);
                        lavaMonster.func_70012_b(posX, posY, posZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)lavaMonster, (World)world, (float)posX, (float)posY, (float)posZ);
                        if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !lavaMonster.func_70601_bi())) continue;
                        ++numberSpawned;
                        _SpecialMobs.debugConsole("Mob Spawned at X " + posX + "  Y " + posY + "  Z " + posZ);
                        world.func_72838_d((Entity)lavaMonster);
                        if (ForgeEventFactory.doSpecialSpawn((EntityLiving)lavaMonster, (World)world, (float)posX, (float)posY, (float)posZ)) continue block3;
                        lavaMonster.func_110161_a(null);
                        continue block3;
                    }
                }
            }
        }
        return numberSpawned;
    }

    private ChunkPosition getRandomSpawningPointInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
        int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(x, y, z);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world instanceof WorldServer) {
            this.performSpawning((WorldServer)event.world);
        }
    }
}

