/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;
import serverutils.task.Task;

public class TeleportTask
extends Task {
    private final EntityPlayerMP player;
    private final BlockDimPos startPos;
    private final TeleporterDimPos teleporter;
    private final float startHP;
    private final int startSeconds;
    private int secondsLeft;
    private final Task extraTask;
    private final TeleportType teleportType;

    public TeleportTask(TeleportType teleportType, EntityPlayerMP player, int secStart, TeleporterDimPos to, @Nullable Task task) {
        super(0L);
        this.teleportType = teleportType;
        this.player = player;
        this.startPos = new BlockDimPos((EntityPlayer)player);
        this.startHP = player.func_110143_aJ();
        this.teleporter = to;
        this.startSeconds = secStart;
        this.secondsLeft = secStart;
        this.extraTask = task;
    }

    @Override
    public void execute(Universe universe) {
        if (!this.startPos.equalsPos(new BlockDimPos((EntityPlayer)this.player)) || this.startHP > this.player.func_110143_aJ()) {
            this.player.func_145747_a(StringUtils.color("serverutilities.lang.warps.cancelled", EnumChatFormatting.RED, new Object[0]));
        } else if (this.secondsLeft <= 1) {
            Entity mount = this.player.field_70154_o;
            this.player.func_70078_a(null);
            if (mount != null) {
                this.teleporter.teleport(mount);
            }
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)this.player));
            data.setLastTeleport(this.teleportType, new BlockDimPos((EntityPlayer)this.player));
            this.teleporter.teleport((Entity)this.player);
            if (this.secondsLeft != 0) {
                this.player.func_145747_a(ServerUtilities.lang((ICommandSender)this.player, "teleporting", new Object[0]));
            }
            if (this.extraTask != null) {
                this.extraTask.execute(universe);
            }
        } else {
            --this.secondsLeft;
            this.setNextTime(System.currentTimeMillis() + Ticks.SECOND.millis());
            IChatComponent component = StringUtils.color(ServerUtilities.lang("stand_still", this.startSeconds).func_150258_a(" [" + this.secondsLeft + "]"), EnumChatFormatting.GOLD);
            ServerUtilitiesNotifications.TELEPORT_WARMUP.createNotification(component).setVanilla(true).send((EntityPlayer)this.player);
            universe.scheduleTask(this);
        }
    }
}

