/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.util;

import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CombinedInventory
implements IInventory {
    private final TreeRangeMap<Integer, IInventory> inventoryRanges = TreeRangeMap.create();
    private final Map<Range<Integer>, IInventory> inventoryMap = this.inventoryRanges.asMapOfRanges();
    private IInventory activeInventory;
    private int size;

    public void addInventory(IInventory inventory, Range<Integer> slotRange) {
        this.size += (Integer)slotRange.upperEndpoint() - (Integer)slotRange.lowerEndpoint();
        this.inventoryRanges.put(slotRange, (Object)inventory);
    }

    public void addInventories(IInventory ... inventories) {
        for (IInventory inventory : inventories) {
            this.addInventory(inventory);
        }
    }

    public void addInventory(IInventory inventory) {
        Range slotRange = Range.closedOpen((Comparable)Integer.valueOf(this.size), (Comparable)Integer.valueOf(this.size + inventory.func_70302_i_()));
        this.size += inventory.func_70302_i_();
        this.inventoryRanges.put(slotRange, (Object)inventory);
    }

    @Nullable
    public <T extends IInventory> T getInventory(Class<T> inventoryClass) {
        for (IInventory inventory : this.inventoryMap.values()) {
            if (!inventoryClass.isInstance(inventory)) continue;
            return (T)((IInventory)inventoryClass.cast(inventory));
        }
        return null;
    }

    @Nullable
    public <T extends IInventory> T getInventory(Class<T> inventoryClass, int slot) {
        IInventory inventory = (IInventory)this.inventoryRanges.get((Comparable)Integer.valueOf(slot));
        return (T)(inventoryClass.isInstance(inventory) ? (IInventory)inventoryClass.cast(inventory) : null);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        Map.Entry entry = this.inventoryRanges.getEntry((Comparable)Integer.valueOf(index));
        if (entry != null) {
            this.activeInventory = (IInventory)entry.getValue();
            return this.activeInventory.func_70301_a(index - (Integer)((Range)entry.getKey()).lowerEndpoint());
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        Map.Entry entry = this.inventoryRanges.getEntry((Comparable)Integer.valueOf(index));
        if (entry != null) {
            this.activeInventory = (IInventory)entry.getValue();
            return this.activeInventory.func_70298_a(index - (Integer)((Range)entry.getKey()).lowerEndpoint(), count);
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        Map.Entry entry = this.inventoryRanges.getEntry((Comparable)Integer.valueOf(index));
        if (entry != null) {
            this.activeInventory = (IInventory)entry.getValue();
            return this.activeInventory.func_70304_b(index - (Integer)((Range)entry.getKey()).lowerEndpoint());
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        Map.Entry entry = this.inventoryRanges.getEntry((Comparable)Integer.valueOf(index));
        if (entry != null) {
            this.activeInventory = (IInventory)entry.getValue();
            this.activeInventory.func_70299_a(index - (Integer)((Range)entry.getKey()).lowerEndpoint(), stack);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        Map.Entry entry = this.inventoryRanges.getEntry((Comparable)Integer.valueOf(index));
        if (entry != null) {
            this.activeInventory = (IInventory)entry.getValue();
            return this.activeInventory.func_94041_b(index - (Integer)((Range)entry.getKey()).lowerEndpoint(), stack);
        }
        return false;
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.activeInventory == null ? 64 : this.activeInventory.func_70297_j_();
    }

    public void func_70296_d() {
        if (this.activeInventory != null) {
            this.activeInventory.func_70296_d();
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

