/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.invsee.util.CombinedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ImageIcon;
import serverutils.lib.icon.ItemIcon;
import serverutils.lib.icon.PartIcon;
import tconstruct.armor.inventory.SlotAccessory;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.KnapsackInventory;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.accessory.IAccessory;

public class TiCInventory
implements IModdedInventory {
    private static final Icon[] SLOT_OVERLAYS = new Icon[7];
    private static final int KNAPSACK_SIZE = new KnapsackInventory().func_70302_i_();

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        CombinedInventory combined = new CombinedInventory();
        TPlayerStats stats = TPlayerStats.get((EntityPlayer)player);
        combined.addInventories(new IInventory[]{stats.knapsack, stats.armor});
        return combined;
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        CombinedInventory combined = new CombinedInventory();
        KnapsackInventory knapsack = new KnapsackInventory();
        ArmorExtendedOffline armor = new ArmorExtendedOffline();
        NBTTagCompound tinkerTag = player.getPlayerNBT().func_74775_l("TConstruct");
        armor.readFromNBT(tinkerTag);
        knapsack.readFromNBT(tinkerTag);
        combined.addInventories(new IInventory[]{knapsack, armor});
        return combined;
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        CombinedInventory combined = new CombinedInventory();
        KnapsackInventory knapsack = new KnapsackInventory();
        ArmorExtended armor = new ArmorExtended();
        knapsack.init(player);
        armor.init(player);
        combined.addInventories(new IInventory[]{knapsack, armor});
        return combined;
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return ItemIcon.getItemIcon((Item)Items.field_151163_ad);
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "TiC Bag & Accessories";
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        ArmorExtended armor;
        if (player.isOnline()) {
            return;
        }
        CombinedInventory combined = (CombinedInventory)inventory;
        NBTTagCompound tag = player.getPlayerNBT();
        NBTTagCompound tinkerTag = tag.func_74775_l("TConstruct");
        KnapsackInventory knapsack = combined.getInventory(KnapsackInventory.class);
        if (knapsack != null) {
            knapsack.saveToNBT(tinkerTag);
        }
        if ((armor = combined.getInventory(ArmorExtended.class)) != null) {
            armor.saveToNBT(tinkerTag);
        }
        tag.func_74782_a("TConstruct", (NBTBase)tinkerTag);
        player.setPlayerNBT(tag);
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        if (index < KNAPSACK_SIZE) {
            return new Slot(inventory, index, x, y);
        }
        return new SlotAccessory(inventory, index, x, y, index < 4 ? 1 : 10){

            public boolean func_75214_a(@Nullable ItemStack stack) {
                IAccessory accessory;
                Item item = stack == null ? null : stack.func_77973_b();
                return item instanceof IAccessory && (accessory = (IAccessory)item).canEquipAccessory(stack, this.getSlotIndex() - KNAPSACK_SIZE);
            }
        };
    }

    @Override
    @Nullable
    public Icon getSlotOverlay(Slot slot) {
        if (!(slot instanceof SlotAccessory)) {
            return null;
        }
        int index = slot.getSlotIndex() - KNAPSACK_SIZE;
        if (index < 0 || index >= SLOT_OVERLAYS.length) {
            return null;
        }
        return SLOT_OVERLAYS[index];
    }

    static {
        ImageIcon icon = new ImageIcon(new ResourceLocation("tinker", "textures/gui/armorextended.png"));
        TiCInventory.SLOT_OVERLAYS[0] = new PartIcon(icon, 177, 10, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[1] = new PartIcon(icon, 177, 28, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[2] = new PartIcon(icon, 213, 10, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[3] = new PartIcon(icon, 213, 28, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[4] = new PartIcon(icon, 231, 1, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[5] = new PartIcon(icon, 231, 19, 16, 16, 4);
        TiCInventory.SLOT_OVERLAYS[6] = new PartIcon(icon, 231, 37, 16, 16, 4);
    }

    public static class ArmorExtendedOffline
    extends ArmorExtended {
        public void func_70296_d() {
        }

        public ItemStack func_70298_a(int slot, int quantity) {
            if (this.inventory[slot] == null) {
                return null;
            }
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }

        public void func_70299_a(int slot, @Nullable ItemStack itemstack) {
            this.inventory[slot] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }
}

