/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.chunks;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ClaimResult;
import serverutils.data.ClaimedChunks;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;
import serverutils.lib.math.ChunkDimPos;

public class CmdClaimAs
extends CmdBase {
    public CmdClaimAs() {
        super("claim_as", CmdBase.Level.OP);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (ForgeTeam team : Universe.get().getTeams()) {
                if (!team.type.isServer) continue;
                list.add(team.getId());
            }
            return CmdClaimAs.func_71531_a((String[])args, list);
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        this.checkArgs(sender, args, 1);
        ForgeTeam team = CommandUtils.getTeam(sender, args[0]);
        if (!team.type.isServer) {
            throw ServerUtilities.error(sender, "commands.chunks.claim_as.team_not_server", args[0]);
        }
        int radius = 0;
        if (args.length >= 2) {
            radius = CmdClaimAs.func_71532_a((ICommandSender)sender, (String)args[1], (int)0, (int)30);
        }
        EntityPlayerMP player = CmdClaimAs.func_71521_c((ICommandSender)sender);
        ForgePlayer p = new ForgePlayer(Universe.get(), UUID.nameUUIDFromBytes("FakePlayerClaimAs".getBytes(StandardCharsets.UTF_8)), "FakePlayerClaimAs");
        p.team = team;
        ChunkDimPos pos = new ChunkDimPos((Entity)player);
        for (int x = -radius; x <= radius; ++x) {
            block6: for (int z = -radius; z <= radius; ++z) {
                ChunkDimPos pos1 = new ChunkDimPos(pos.posX + x, pos.posZ + z, pos.dim);
                ClaimResult result = ClaimedChunks.instance.claimChunk(p, pos1, false);
                if (x != 0 || z != 0) continue;
                switch (result) {
                    case SUCCESS: {
                        ServerUtilitiesNotifications.CHUNK_MODIFIED.send((EntityPlayer)player, "serverutilities.lang.chunks.chunk_claimed", new Object[0]);
                        ServerUtilitiesNotifications.updateChunkMessage(player, pos);
                        continue block6;
                    }
                    case DIMENSION_BLOCKED: {
                        ServerUtilitiesNotifications.CANT_MODIFY_CHUNK.createNotification("serverutilities.lang.chunks.claiming_not_enabled_dim", new Object[0]).setError().send((EntityPlayer)player);
                        continue block6;
                    }
                    case NO_POWER: {
                        continue block6;
                    }
                    default: {
                        ServerUtilitiesNotifications.CANT_MODIFY_CHUNK.createNotification("serverutilities.lang.chunks.cant_modify_chunk", new Object[0]).setError().send((EntityPlayer)player);
                    }
                }
            }
        }
    }
}

