/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.chunks;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ClaimedChunks;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.math.ChunkDimPos;

public class CmdClaim
extends CmdBase {
    public CmdClaim() {
        super("claim", CmdBase.Level.ALL);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        EntityPlayerMP player = CmdClaim.func_71521_c((ICommandSender)sender);
        ForgePlayer p = CommandUtils.getSelfOrOther((ICommandSender)player, args, 0, "serverutilities.other_player.claims.claim");
        ChunkDimPos pos = new ChunkDimPos((Entity)player);
        if (!player.func_110124_au().equals(p.getId()) && !ClaimedChunks.instance.canPlayerModify(p, pos, "serverutilities.other_player.claims.claim")) {
            ServerUtilitiesNotifications.CANT_MODIFY_CHUNK.createNotification("serverutilities.lang.chunks.cant_modify_chunk", new Object[0]).setError().send((EntityPlayer)player);
            return;
        }
        switch (ClaimedChunks.instance.claimChunk(p, pos)) {
            case SUCCESS: {
                ServerUtilitiesNotifications.CHUNK_MODIFIED.send((EntityPlayer)player, "serverutilities.lang.chunks.chunk_claimed", new Object[0]);
                ServerUtilitiesNotifications.updateChunkMessage(player, pos);
                break;
            }
            case DIMENSION_BLOCKED: {
                ServerUtilitiesNotifications.CANT_MODIFY_CHUNK.createNotification("serverutilities.lang.chunks.claiming_not_enabled_dim", new Object[0]).setError().send((EntityPlayer)player);
                break;
            }
            case NO_POWER: {
                break;
            }
            default: {
                ServerUtilitiesNotifications.CANT_MODIFY_CHUNK.createNotification("serverutilities.lang.chunks.cant_modify_chunk", new Object[0]).setError().send((EntityPlayer)player);
            }
        }
    }
}

