/*
 * Decompiled with CFR 0.152.
 */
package serverutils.pregenerator.filemanager.readwriters;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileReadWriter {
    protected RandomAccessFile randomAccessFile;
    protected boolean randomAccessFileIsClosed = false;
    protected final Path filePath;

    public FileReadWriter(Path path) throws IOException {
        this.filePath = path;
        this.randomAccessFile = new RandomAccessFile(this.filePath.toFile(), "rw");
    }

    public void close() throws IOException {
        this.randomAccessFileIsClosed = true;
        this.randomAccessFile.close();
    }

    public void clearFile() throws IOException {
        this.randomAccessFile.setLength(0L);
    }

    public void writeDouble(double value) throws IOException {
        this.randomAccessFile.writeDouble(value);
    }

    public void writeInt(int value) throws IOException {
        this.randomAccessFile.writeInt(value);
    }

    public void openForWriting() throws IOException {
        if (this.randomAccessFile == null || !this.filePath.toFile().exists() || this.randomAccessFileIsClosed) {
            this.randomAccessFileIsClosed = false;
            this.randomAccessFile = new RandomAccessFile(this.filePath.toFile(), "rw");
        }
    }

    public void openForReading() throws IOException {
        if (this.randomAccessFile == null || !this.filePath.toFile().exists() || this.randomAccessFileIsClosed) {
            this.randomAccessFileIsClosed = false;
            this.randomAccessFile = new RandomAccessFile(this.filePath.toFile(), "r");
        }
    }

    public int readInt() throws IOException {
        return this.randomAccessFile.readInt();
    }

    public double readDouble() throws IOException {
        return this.randomAccessFile.readDouble();
    }

    public void deleteFile() throws IOException {
        Files.deleteIfExists(this.filePath);
    }
}

