/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.io;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Bits {
    private static final int MAX_BYTE = 255;
    private static final int MAX_SHORT = 65535;
    private static final long MAX_INT = 0xFFFFFFFFL;

    public static boolean getFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static int setFlag(int flags, int flag, boolean v) {
        if (v) {
            return flags | flag;
        }
        return flags & ~flag;
    }

    public static int toInt(boolean[] b) {
        int d = 0;
        for (int i = 0; i < b.length; ++i) {
            d |= (b[i] ? 1 : 0) << i;
        }
        return d;
    }

    public static void toBool(boolean[] b, int d) {
        for (int j = 0; j < b.length; ++j) {
            b[j] = (d >> j & 1) == 1;
        }
    }

    public static long intsToLong(int a, int b) {
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static int intFromLongA(long l) {
        return (int)(l >> 32);
    }

    public static int intFromLongB(long l) {
        return (int)l;
    }

    public static int shortsToInt(int a, int b) {
        return (short)a << 16 | (short)b & 0xFFFF;
    }

    public static short shortFromIntA(int i) {
        return (short)(i >> 16);
    }

    public static short shortFromIntB(int i) {
        return (short)(i & 0xFFFF);
    }

    public static short bytesToShort(int a, int b) {
        return (short)((a & 0xFF) << 8 | b & 0xFF);
    }

    public static byte byteFromShortA(short s) {
        return (byte)(s >> 8 & 0xFF);
    }

    public static byte byteFromShortB(short s) {
        return (byte)(s & 0xFF);
    }

    public static int toUShort(byte[] b, int off) {
        int ch1 = b[off] & 0xFF;
        int ch2 = b[off + 1] & 0xFF;
        return (ch1 << 8) + ch2;
    }

    public static int toInt(byte[] b, int off) {
        int ch1 = b[off] & 0xFF;
        int ch2 = b[off + 1] & 0xFF;
        int ch3 = b[off + 2] & 0xFF;
        int ch4 = b[off + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static long toLong(byte[] b, int off) {
        return ((long)b[off] << 56) + ((long)(b[off + 1] & 0xFF) << 48) + ((long)(b[off + 2] & 0xFF) << 40) + ((long)(b[off + 3] & 0xFF) << 32) + ((long)(b[off + 4] & 0xFF) << 24) + (long)((b[off + 5] & 0xFF) << 16) + (long)((b[off + 6] & 0xFF) << 8) + (long)(b[off + 7] & 0xFF);
    }

    public static UUID toUUID(byte[] b, int off) {
        long msb = Bits.toLong(b, off);
        long lsb = Bits.toLong(b, off + 8);
        return new UUID(msb, lsb);
    }

    public static List<UUID> toUUIDList(byte[] b) {
        if (b.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<UUID> list = new ArrayList<UUID>(b.length / 16);
        for (int i = 0; i < b.length; i += 16) {
            list.add(Bits.toUUID(b, i));
        }
        return list;
    }

    public static void fromUShort(byte[] b, int off, int v) {
        b[off] = (byte)(v >>> 8);
        b[off + 1] = (byte)v;
    }

    public static void fromInt(byte[] b, int off, int v) {
        b[off] = (byte)(v >>> 24);
        b[off + 1] = (byte)(v >>> 16);
        b[off + 2] = (byte)(v >>> 8);
        b[off + 3] = (byte)v;
    }

    public static void fromLong(byte[] b, int off, long v) {
        b[off] = (byte)(v >>> 56);
        b[off + 1] = (byte)(v >>> 48);
        b[off + 2] = (byte)(v >>> 40);
        b[off + 3] = (byte)(v >>> 32);
        b[off + 4] = (byte)(v >>> 24);
        b[off + 5] = (byte)(v >>> 16);
        b[off + 6] = (byte)(v >>> 8);
        b[off + 7] = (byte)v;
    }

    public static void fromUUID(byte[] b, int off, UUID uuid) {
        Bits.fromLong(b, off, uuid.getMostSignificantBits());
        Bits.fromLong(b, off + 8, uuid.getLeastSignificantBits());
    }

    public static byte[] fromUUIDList(Collection<UUID> c) {
        byte[] b = new byte[c.size() * 16];
        int idx = 0;
        for (UUID id : c) {
            Bits.fromUUID(b, idx, id);
            idx += 16;
        }
        return b;
    }
}

