/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.data.ClaimedChunk;
import serverutils.events.team.ForgeTeamConfigEvent;
import serverutils.events.team.ForgeTeamConfigSavedEvent;
import serverutils.events.team.ForgeTeamDataEvent;
import serverutils.events.team.ForgeTeamOwnerChangedEvent;
import serverutils.events.team.ForgeTeamPlayerJoinedEvent;
import serverutils.events.team.ForgeTeamPlayerLeftEvent;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.NBTDataStorage;
import serverutils.lib.data.TeamType;
import serverutils.lib.data.Universe;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.PlayerHeadIcon;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FinalIDObject;
import serverutils.lib.util.INBTSerializable;
import serverutils.lib.util.StringUtils;

public class ForgeTeam
extends FinalIDObject
implements INBTSerializable<NBTTagCompound>,
IConfigCallback {
    public static final int MAX_TEAM_ID_LENGTH = 35;
    public static final Pattern TEAM_ID_PATTERN = Pattern.compile("^[a-z0-9_]{1,35}$");
    private final short uid;
    public final Universe universe;
    public final TeamType type;
    public ForgePlayer owner;
    private final NBTDataStorage dataStorage;
    private String title;
    private String desc;
    private EnumTeamColor color;
    private String icon;
    private boolean freeToJoin;
    private EnumTeamStatus fakePlayerStatus;
    private final Collection<ForgePlayer> requestingInvite;
    public final Map<ForgePlayer, EnumTeamStatus> players;
    private ConfigGroup cachedConfig;
    private IChatComponent cachedTitle;
    private Icon cachedIcon;
    public boolean needsSaving;
    private long lastActivity;
    public final Set<ClaimedChunk> claimedChunks = new HashSet<ClaimedChunk>();

    public ForgeTeam(Universe u, short id, String n, TeamType t) {
        super(n, t.isNone ? 0 : 15);
        this.uid = id;
        this.universe = u;
        this.type = t;
        this.title = "";
        this.desc = "";
        this.color = EnumTeamColor.BLUE;
        this.icon = "";
        this.freeToJoin = false;
        this.fakePlayerStatus = EnumTeamStatus.ALLY;
        this.requestingInvite = new HashSet<ForgePlayer>();
        this.players = new HashMap<ForgePlayer, EnumTeamStatus>();
        this.dataStorage = new NBTDataStorage();
        new ForgeTeamDataEvent(this, this.dataStorage).post();
        this.clearCache();
        this.cachedIcon = null;
        this.needsSaving = false;
        this.lastActivity = 0L;
    }

    public final short getUID() {
        return this.uid;
    }

    @Override
    public final int hashCode() {
        return this.uid;
    }

    @Override
    public final boolean equals(Object o) {
        return o == this || this.uid == Objects.hashCode(o);
    }

    public final String getUIDCode() {
        return String.format("%04X", this.uid);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.owner != null) {
            nbt.func_74778_a("Owner", this.owner.getName());
        }
        nbt.func_74778_a("Title", this.title);
        nbt.func_74778_a("Desc", this.desc);
        nbt.func_74778_a("Color", EnumTeamColor.NAME_MAP.getName(this.color));
        nbt.func_74778_a("Icon", this.icon);
        nbt.func_74757_a("FreeToJoin", this.freeToJoin);
        nbt.func_74778_a("FakePlayerStatus", EnumTeamStatus.NAME_MAP_PERMS.getName(this.fakePlayerStatus));
        nbt.func_74772_a("LastActivity", this.lastActivity);
        NBTTagCompound nbt1 = new NBTTagCompound();
        if (!this.players.isEmpty()) {
            for (Map.Entry<ForgePlayer, EnumTeamStatus> entry : this.players.entrySet()) {
                nbt1.func_74778_a(entry.getKey().getName(), entry.getValue().getName());
            }
        }
        nbt.func_74782_a("Players", (NBTBase)nbt1);
        NBTTagList list = new NBTTagList();
        for (ForgePlayer player : this.requestingInvite) {
            list.func_74742_a((NBTBase)new NBTTagString(player.getName()));
        }
        nbt.func_74782_a("RequestingInvite", (NBTBase)list);
        nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        ForgePlayer player;
        int i;
        this.owner = this.universe.getPlayer(nbt.func_74779_i("Owner"));
        if (!this.isValid()) {
            return;
        }
        this.title = nbt.func_74779_i("Title");
        this.desc = nbt.func_74779_i("Desc");
        this.color = EnumTeamColor.NAME_MAP.get(nbt.func_74779_i("Color"));
        this.icon = nbt.func_74779_i("Icon");
        this.freeToJoin = nbt.func_74767_n("FreeToJoin");
        this.fakePlayerStatus = EnumTeamStatus.NAME_MAP_PERMS.get(nbt.func_74779_i("FakePlayerStatus"));
        this.lastActivity = nbt.func_74763_f("LastActivity");
        this.players.clear();
        if (nbt.func_74764_b("Players")) {
            NBTTagCompound nbt1 = nbt.func_74775_l("Players");
            for (String s : nbt1.func_150296_c()) {
                EnumTeamStatus status;
                ForgePlayer player2 = this.universe.getPlayer(s);
                if (player2 == null || !(status = EnumTeamStatus.NAME_MAP.get(nbt1.func_74779_i(s))).canBeSet()) continue;
                this.setStatus(player2, status);
            }
        }
        NBTTagList list = nbt.func_150295_c("RequestingInvite", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            player = this.universe.getPlayer(list.func_150307_f(i));
            if (player == null || this.isMember(player)) continue;
            this.setRequestingInvite(player, true);
        }
        list = nbt.func_150295_c("Invited", 8);
        for (i = 0; i < list.func_74745_c(); ++i) {
            player = this.universe.getPlayer(list.func_150307_f(i));
            if (player == null || this.isMember(player)) continue;
            this.setStatus(player, EnumTeamStatus.INVITED);
        }
        this.dataStorage.deserializeNBT(nbt.func_74775_l("Data"));
    }

    public void clearCache() {
        this.cachedTitle = null;
        this.cachedIcon = null;
        this.cachedConfig = null;
        this.dataStorage.clearCache();
    }

    public void markDirty() {
        this.needsSaving = true;
        this.universe.checkSaving = true;
    }

    public NBTDataStorage getData() {
        return this.dataStorage;
    }

    @Nullable
    public ForgePlayer getOwner() {
        return this.type.isPlayer ? this.owner : null;
    }

    public IChatComponent getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle;
        }
        this.cachedTitle = this.title.isEmpty() ? (this.getOwner() != null ? this.getOwner().getDisplayName().func_150258_a("'s Team") : new ChatComponentTranslation("serverutilities.lang.team.no_team", new Object[0])) : new ChatComponentText(this.title);
        this.cachedTitle = StringUtils.color(this.cachedTitle, this.getColor().getEnumChatFormatting());
        return this.cachedTitle;
    }

    public IChatComponent getCommandTitle() {
        IChatComponent component = this.getTitle().func_150259_f();
        if (!this.isValid()) {
            return component;
        }
        component.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText("/team info " + this.getId())));
        component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team info " + this.getId()));
        component.func_150256_b().func_150238_a(this.getColor().getEnumChatFormatting());
        return component;
    }

    public void setTitle(String s) {
        if (!this.title.equals(s)) {
            this.title = s;
            this.markDirty();
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String s) {
        if (!this.desc.equals(s)) {
            this.desc = s;
            this.markDirty();
        }
    }

    public EnumTeamColor getColor() {
        return this.color;
    }

    public void setColor(EnumTeamColor col) {
        if (this.color != col) {
            this.color = col;
            this.markDirty();
        }
    }

    public Icon getIcon() {
        if (this.cachedIcon == null) {
            this.cachedIcon = this.icon.isEmpty() ? (this.getOwner() != null ? new PlayerHeadIcon(this.getOwner().getProfile().getId()) : this.getColor().getColor()) : Icon.getIcon(this.icon);
        }
        return this.cachedIcon;
    }

    public void setIcon(String s) {
        if (!this.icon.equals(s)) {
            this.icon = s;
            this.markDirty();
        }
    }

    public boolean isFreeToJoin() {
        return this.freeToJoin;
    }

    public void setFreeToJoin(boolean b) {
        if (this.freeToJoin != b) {
            this.freeToJoin = b;
            this.markDirty();
        }
    }

    public EnumTeamStatus getFakePlayerStatus(ForgePlayer player) {
        return this.fakePlayerStatus;
    }

    public EnumTeamStatus getHighestStatus(@Nullable ForgePlayer player) {
        if (player == null) {
            return EnumTeamStatus.NONE;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus;
        }
        if (this.isOwner(player)) {
            return EnumTeamStatus.OWNER;
        }
        if (this.isModerator(player)) {
            return EnumTeamStatus.MOD;
        }
        if (this.isMember(player)) {
            return EnumTeamStatus.MEMBER;
        }
        if (this.isEnemy(player)) {
            return EnumTeamStatus.ENEMY;
        }
        if (this.isAlly(player)) {
            return EnumTeamStatus.ALLY;
        }
        if (this.isInvited(player)) {
            return EnumTeamStatus.INVITED;
        }
        return EnumTeamStatus.NONE;
    }

    private EnumTeamStatus getSetStatus(@Nullable ForgePlayer player) {
        if (player == null || !this.isValid()) {
            return EnumTeamStatus.NONE;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus;
        }
        if (this.type == TeamType.SERVER && this.getId().equals("singleplayer")) {
            return EnumTeamStatus.MOD;
        }
        EnumTeamStatus status = this.players.get(player);
        return status == null ? EnumTeamStatus.NONE : status;
    }

    public boolean hasStatus(@Nullable ForgePlayer player, EnumTeamStatus status) {
        boolean bl;
        if (player == null || !this.isValid()) {
            return false;
        }
        if (player.isFake()) {
            return this.getFakePlayerStatus(player).isEqualOrGreaterThan(status);
        }
        switch (status) {
            case NONE: {
                bl = true;
                break;
            }
            case ENEMY: {
                bl = this.isEnemy(player);
                break;
            }
            case ALLY: {
                bl = this.isAlly(player);
                break;
            }
            case INVITED: {
                bl = this.isInvited(player);
                break;
            }
            case MEMBER: {
                bl = this.isMember(player);
                break;
            }
            case MOD: {
                bl = this.isModerator(player);
                break;
            }
            case OWNER: {
                bl = this.isOwner(player);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean setStatus(@Nullable ForgePlayer player, EnumTeamStatus status) {
        if (player == null || !this.isValid() || player.isFake()) {
            return false;
        }
        if (status == EnumTeamStatus.OWNER) {
            if (!this.isMember(player)) {
                return false;
            }
            if (!player.equalsPlayer(this.getOwner())) {
                this.universe.clearCache();
                ForgePlayer oldOwner = this.getOwner();
                this.owner = player;
                this.players.remove(player);
                new ForgeTeamOwnerChangedEvent(this, oldOwner).post();
                if (oldOwner != null) {
                    oldOwner.markDirty();
                }
                this.owner.markDirty();
                this.markDirty();
                return true;
            }
            return false;
        }
        if (!status.isNone() && status.canBeSet()) {
            if (this.players.put(player, status) != status) {
                this.universe.clearCache();
                player.markDirty();
                this.markDirty();
                return true;
            }
        } else if (this.players.remove(player) != status) {
            this.universe.clearCache();
            player.markDirty();
            this.markDirty();
            return true;
        }
        return false;
    }

    public <C extends Collection<ForgePlayer>> C getPlayersWithStatus(C collection, EnumTeamStatus status) {
        if (!this.isValid()) {
            return collection;
        }
        for (ForgePlayer player : this.universe.getPlayers()) {
            if (player.isFake() || !this.hasStatus(player, status)) continue;
            collection.add((ForgePlayer)player);
        }
        return collection;
    }

    public List<ForgePlayer> getPlayersWithStatus(EnumTeamStatus status) {
        return this.isValid() ? (List)this.getPlayersWithStatus(new ArrayList(), status) : Collections.emptyList();
    }

    public boolean addMember(ForgePlayer player, boolean simulate) {
        if (this.isValid() && (this.isOwner(player) || this.isInvited(player)) && !this.isMember(player)) {
            if (!simulate) {
                this.universe.clearCache();
                player.team = this;
                this.players.remove(player);
                this.requestingInvite.remove(player);
                ForgeTeamPlayerJoinedEvent event = new ForgeTeamPlayerJoinedEvent(player);
                event.post();
                if (event.getDisplayGui() != null) {
                    event.getDisplayGui().run();
                }
                player.markDirty();
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    public boolean removeMember(ForgePlayer player) {
        if (!this.isValid() || !this.isMember(player)) {
            return false;
        }
        if (this.getMembers().size() == 1) {
            this.universe.clearCache();
            new ForgeTeamPlayerLeftEvent(player).post();
            if (this.type.isPlayer) {
                this.delete();
            } else {
                this.setStatus(player, EnumTeamStatus.NONE);
            }
            player.team = this.universe.getTeam("");
            player.markDirty();
            this.markDirty();
        } else if (this.isOwner(player)) {
            return false;
        }
        this.universe.clearCache();
        new ForgeTeamPlayerLeftEvent(player).post();
        player.team = this.universe.getTeam("");
        this.setStatus(player, EnumTeamStatus.NONE);
        player.markDirty();
        this.markDirty();
        return true;
    }

    public void delete() {
        this.universe.removeTeam(this);
    }

    public List<ForgePlayer> getMembers() {
        return this.getPlayersWithStatus(EnumTeamStatus.MEMBER);
    }

    public boolean isMember(@Nullable ForgePlayer player) {
        if (player == null) {
            return false;
        }
        if (player.isFake()) {
            return this.fakePlayerStatus.isEqualOrGreaterThan(EnumTeamStatus.MEMBER);
        }
        return this.isValid() && this.equalsTeam(player.team);
    }

    public boolean isAlly(@Nullable ForgePlayer player) {
        return this.isValid() && (this.isMember(player) || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.ALLY));
    }

    public boolean isInvited(@Nullable ForgePlayer player) {
        return this.isValid() && (this.isMember(player) || (this.isFreeToJoin() || this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.INVITED)) && !this.isEnemy(player));
    }

    public boolean setRequestingInvite(@Nullable ForgePlayer player, boolean value) {
        if (player != null && this.isValid()) {
            if (value) {
                if (this.requestingInvite.add(player)) {
                    player.markDirty();
                    this.markDirty();
                    return true;
                }
            } else if (this.requestingInvite.remove(player)) {
                player.markDirty();
                this.markDirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isRequestingInvite(@Nullable ForgePlayer player) {
        return player != null && this.isValid() && !this.isMember(player) && this.requestingInvite.contains(player) && !this.isEnemy(player);
    }

    public boolean isEnemy(@Nullable ForgePlayer player) {
        return this.getSetStatus(player) == EnumTeamStatus.ENEMY;
    }

    public boolean isModerator(@Nullable ForgePlayer player) {
        return this.isOwner(player) || this.isMember(player) && this.getSetStatus(player).isEqualOrGreaterThan(EnumTeamStatus.MOD);
    }

    public boolean isOwner(@Nullable ForgePlayer player) {
        return player != null && player.equalsPlayer(this.getOwner());
    }

    public ConfigGroup getSettings() {
        if (this.cachedConfig == null) {
            this.cachedConfig = ConfigGroup.newGroup("team_config");
            this.cachedConfig.setDisplayName(new ChatComponentTranslation("gui.settings", new Object[0]).func_150257_a(StringUtils.bold(StringUtils.color((IChatComponent)new ChatComponentText(" #" + this.getId()), EnumChatFormatting.DARK_GRAY), false)));
            ForgeTeamConfigEvent event = new ForgeTeamConfigEvent(this, this.cachedConfig);
            event.post();
            ConfigGroup main = this.cachedConfig.getGroup("serverutilities");
            main.setDisplayName((IChatComponent)new ChatComponentText("Server Utilities"));
            main.addBool("free_to_join", () -> this.freeToJoin, v -> {
                this.freeToJoin = v;
            }, false);
            ConfigGroup display = main.getGroup("display");
            display.addEnum("color", () -> this.color, v -> {
                this.color = v;
            }, EnumTeamColor.NAME_MAP);
            display.addEnum("fake_player_status", () -> this.fakePlayerStatus, v -> {
                this.fakePlayerStatus = v;
            }, EnumTeamStatus.NAME_MAP_PERMS);
            display.addString("title", () -> this.title, v -> {
                this.title = v;
            }, "");
            display.addString("desc", () -> this.desc, v -> {
                this.desc = v;
            }, "");
        }
        return this.cachedConfig;
    }

    public boolean isValid() {
        if (this.type.isNone) {
            return false;
        }
        return this.type.isServer || this.getOwner() != null;
    }

    public boolean equalsTeam(@Nullable ForgeTeam team) {
        return team == this || this.uid == Objects.hashCode(team);
    }

    public boolean anyPlayerHasPermission(String permission, EnumTeamStatus status) {
        for (ForgePlayer player : this.getPlayersWithStatus(status)) {
            if (!player.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean anyMemberHasPermission(String permission) {
        return this.anyPlayerHasPermission(permission, EnumTeamStatus.MEMBER);
    }

    public File getDataFile(String ext) {
        File oldExtFile;
        File extFile;
        File dir = new File(this.universe.dataFolder, "teams/");
        if (ext.isEmpty()) {
            return new File(dir, this.getId() + ".dat");
        }
        File extFolder = new File(dir, ext);
        if (!extFolder.exists()) {
            extFolder.mkdirs();
        }
        if (!(extFile = new File(extFolder, this.getId() + ".dat")).exists() && (oldExtFile = new File(dir, this.getId() + "." + ext + ".dat")).exists()) {
            oldExtFile.renameTo(extFile);
            oldExtFile.deleteOnExit();
        }
        return extFile;
    }

    @Override
    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.clearCache();
        this.markDirty();
        new ForgeTeamConfigSavedEvent(this, group, sender).post();
    }

    public List<EntityPlayerMP> getOnlineMembers() {
        ArrayList<EntityPlayerMP> list = new ArrayList<EntityPlayerMP>();
        for (ForgePlayer player : this.getMembers()) {
            EntityPlayerMP p = player.getNullablePlayer();
            if (p == null) continue;
            list.add(p);
        }
        return list;
    }

    public long getLastActivity() {
        if (this.lastActivity == 0L) {
            long latestActivity = 0L;
            for (ForgePlayer player : this.getMembers()) {
                latestActivity = Math.max(player.getLastTimeSeen(), latestActivity);
            }
            this.lastActivity = System.currentTimeMillis() - Ticks.get(this.universe.ticks.ticks() - latestActivity).millis();
        }
        return this.lastActivity;
    }

    public void refreshActivity() {
        this.lastActivity = System.currentTimeMillis();
    }

    public Ticks getHighestTimer(String node) {
        Ticks highest = Ticks.NO_TICKS;
        for (ForgePlayer player : this.getMembers()) {
            Ticks ticks = player.getRankConfig(node).getTimer();
            if (ticks.millis() == Ticks.NO_TICKS.millis()) {
                return ticks;
            }
            if (ticks.millis() <= highest.millis()) continue;
            highest = ticks;
        }
        return highest;
    }
}

