/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.lib.math.ChunkDimPos;
import serverutils.pregenerator.ChunkLoaderManager;

public class ServerUtilitiesWorldEventHandler {
    public static final ServerUtilitiesWorldEventHandler INST = new ServerUtilitiesWorldEventHandler();

    @SubscribeEvent
    public void onMobSpawned(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && !ServerUtilitiesWorldEventHandler.isEntityAllowed(event.entity)) {
            event.entity.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onDimensionUnload(WorldEvent.Unload event) {
        if (ClaimedChunks.isActive() && event.world.field_73011_w.field_76574_g != 0) {
            ClaimedChunks.instance.markDirty();
        }
    }

    private static boolean isEntityAllowed(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (ServerUtilitiesConfig.world.safe_spawn && ServerUtilitiesUniverseData.isInSpawn(MinecraftServer.func_71276_C(), new ChunkDimPos(entity))) {
            if (entity instanceof IMob) {
                return false;
            }
            return !(entity instanceof EntityChicken) || entity.field_70153_n == null;
        }
        return true;
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        World world = event.world;
        if (world.field_72995_K || event.getAffectedBlocks().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(event.getAffectedBlocks());
        event.getAffectedBlocks().clear();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        MinecraftServer server = MinecraftServer.func_71276_C();
        Function<ChunkDimPos, Boolean> func = pos -> {
            if (pos.dim == 0 && ServerUtilitiesConfig.world.safe_spawn && ServerUtilitiesUniverseData.isInSpawn(server, pos)) {
                return false;
            }
            if (ServerUtilitiesConfig.world.enable_explosions.isDefault()) {
                ClaimedChunk chunk = ClaimedChunks.isActive() ? ClaimedChunks.instance.getChunk((ChunkDimPos)pos) : null;
                return chunk == null || chunk.hasExplosions();
            }
            return ServerUtilitiesConfig.world.enable_explosions.isTrue();
        };
        for (ChunkPosition pos2 : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(pos2.field_151329_a, pos2.field_151327_b, pos2.field_151328_c, world.field_73011_w.field_76574_g), func).booleanValue()) continue;
            event.getAffectedBlocks().add(pos2);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            int dimensionId = event.world.field_73011_w.field_76574_g;
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (!ChunkLoaderManager.instance.isGenerating() && ChunkLoaderManager.instance.initializeFromPregeneratorFiles(server, dimensionId)) {
                ServerUtilities.LOGGER.info("Pregenerator loaded and running for dimension Id: " + dimensionId);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == ChunkLoaderManager.instance.getDimensionID() && ChunkLoaderManager.instance.isGenerating()) {
            ChunkLoaderManager.instance.reset(false);
        }
    }
}

