/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.compression.ICompress;

public class CommonsCompressor
implements ICompress {
    private ArchiveOutputStream output;

    @Override
    public void createOutputStream(File file) throws IOException {
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(file);
        if (ServerUtilitiesConfig.backups.compression_level == 0) {
            zaos.setMethod(0);
        } else {
            zaos.setLevel(ServerUtilitiesConfig.backups.compression_level);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        if (worldDir != null) {
            zaos.setComment(worldDir.getName());
        }
        this.output = zaos;
    }

    @Override
    public void addFileToArchive(File file, String name) throws IOException {
        ArchiveEntry entry = this.output.createArchiveEntry(file, name);
        this.output.putArchiveEntry(entry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)this.output);
        }
        this.output.closeArchiveEntry();
    }

    @Override
    public void extractArchive(File archive, File dest) throws IOException {
        try (org.apache.commons.compress.archivers.zip.ZipFile zip = new org.apache.commons.compress.archivers.zip.ZipFile(archive);){
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                InputStream in = zip.getInputStream(entry);
                File file = FileUtils.newFile(new File(dest, entry.getName()));
                FileOutputStream out = new FileOutputStream(file);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    @Override
    @Nullable
    public String getWorldName(File file) throws IOException {
        if (file.isDirectory() || !file.getName().endsWith(".zip")) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(file);){
            String string = zipFile.getComment();
            return string;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.output != null) {
            this.output.close();
        }
    }
}

