/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.IChatComponent;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.Bits;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.MouseButton;

public class TextField
extends Widget {
    public String[] text;
    public int textFlags = 0;
    public int maxWidth = 0;
    public int textSpacing = 10;
    public float scale = 1.0f;
    public Color4I textColor = Icon.EMPTY;
    private List<GuiBase.PositionedTextData> textData;

    public TextField(Panel panel) {
        super(panel);
    }

    public TextField addFlags(int flags) {
        this.textFlags |= flags;
        return this;
    }

    public TextField setMaxWidth(int width) {
        this.maxWidth = width;
        return this;
    }

    public TextField setColor(Color4I color) {
        this.textColor = color;
        return this;
    }

    public TextField setScale(float s) {
        this.scale = s;
        return this;
    }

    public TextField setSpacing(int s) {
        this.textSpacing = s;
        return this;
    }

    public TextField setText(String txt) {
        this.text = null;
        this.textData = null;
        txt = txt.trim();
        Theme theme = this.getGui().getTheme();
        if (!txt.isEmpty()) {
            this.text = this.maxWidth == 0 ? txt.split("\n") : theme.listFormattedStringToWidth(txt, this.maxWidth).toArray(StringUtils.EMPTY_ARRAY);
        }
        if (this.text == null || this.text.length == 0) {
            this.text = StringUtils.EMPTY_ARRAY;
        }
        return this.resize(theme);
    }

    public TextField resize(Theme theme) {
        if (this.maxWidth == 0) {
            this.setWidth(0);
            for (String s : this.text) {
                this.setWidth(Math.max(this.width, (int)((float)theme.getStringWidth(s) * this.scale)));
            }
        } else {
            this.setWidth(this.maxWidth);
        }
        this.setHeight((int)((float)(Math.max(1, this.text.length) * this.textSpacing - (this.textSpacing - theme.getFontHeight() + 1)) * this.scale));
        return this;
    }

    public TextField setText(IChatComponent component) {
        this.setText(component.func_150254_d());
        this.textData = this.getGui().getTheme().createDataFrom(component, this.width);
        if (this.textData.isEmpty()) {
            this.textData = null;
        }
        return this;
    }

    @Nullable
    private GuiBase.PositionedTextData getDataAtMouse() {
        if (this.textData == null) {
            return null;
        }
        int x = this.getX();
        int y = this.getY();
        for (GuiBase.PositionedTextData data : this.textData) {
            if (!this.getGui().isMouseOver(data.posX + x, data.posY + y, data.width, data.height)) continue;
            return data;
        }
        return null;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        GuiBase.PositionedTextData data = this.getDataAtMouse();
        if (data != null && data.hoverEvent != null) {
            Collections.addAll(list, data.hoverEvent.func_150702_b().func_150254_d().split("\n"));
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        GuiBase.PositionedTextData data;
        if (this.isMouseOver() && (data = this.getDataAtMouse()) != null && data.clickEvent != null && this.handleClick(GuiHelper.clickEventToString(data.clickEvent))) {
            GuiHelper.playClickSound();
            return true;
        }
        return false;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawBackground(theme, x, y, w, h);
        if (this.text.length == 0) {
            return;
        }
        boolean centered = Bits.getFlag(this.textFlags, 4);
        boolean centeredV = Bits.getFlag(this.textFlags, 32);
        Color4I col = this.textColor;
        if (col.isEmpty()) {
            col = theme.getContentColor(WidgetType.mouseOver(Bits.getFlag(this.textFlags, 16)));
        }
        int tx = x + (centered ? w / 2 : 0);
        int ty = y + (centeredV ? (h - theme.getFontHeight()) / 2 : 0);
        if (this.scale == 1.0f) {
            for (int i = 0; i < this.text.length; ++i) {
                theme.drawString(this.text[i], tx, ty + i * this.textSpacing, col, this.textFlags);
            }
        } else {
            GlStateManager.pushMatrix();
            GlStateManager.translate(tx, ty, 0.0f);
            GlStateManager.scale(this.scale, this.scale, 1.0f);
            for (int i = 0; i < this.text.length; ++i) {
                theme.drawString(this.text[i], 0, i * this.textSpacing, col, this.textFlags);
            }
            GlStateManager.popMatrix();
        }
    }
}

