/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.tp;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.TeleporterDimPos;

public class CmdRTP
extends CmdBase {
    private static final List<Block> UNSAFE_BLOCKS = Arrays.asList(Blocks.field_150434_aF, Blocks.field_150480_ab, Blocks.field_150353_l, Blocks.field_150355_j, Blocks.field_150356_k, Blocks.field_150358_i);

    public CmdRTP() {
        super("rtp", CmdBase.Level.ALL);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CmdRTP.func_71521_c((ICommandSender)sender);
        ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(CommandUtils.getForgePlayer((ICommandSender)player));
        data.checkTeleportCooldown(sender, ServerUtilitiesPlayerData.Timer.RTP);
        ServerUtilitiesPlayerData.Timer.RTP.teleport(player, playerMP -> this.findBlockPos((World)playerMP.field_71133_b.func_71218_a(ServerUtilitiesConfig.world.spawn_dimension), player, 0), null);
    }

    private TeleporterDimPos findBlockPos(World world, EntityPlayerMP player, int depth) {
        int z;
        int y;
        if (++depth > ServerUtilitiesConfig.world.rtp_max_tries) {
            player.func_145747_a(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.rtp.fail", new Object[0]));
            return TeleporterDimPos.of((Entity)player);
        }
        double dist = ServerUtilitiesConfig.world.rtp_min_distance + world.field_73012_v.nextDouble() * (ServerUtilitiesConfig.world.rtp_max_distance - ServerUtilitiesConfig.world.rtp_min_distance);
        double angle = world.field_73012_v.nextDouble() * Math.PI * 2.0;
        int x = MathHelper.func_76128_c((double)(Math.cos(angle) * dist));
        if (!this.isInsideWorldBorder(world, x, y = 256, z = MathHelper.func_76128_c((double)(Math.sin(angle) * dist)))) {
            return this.findBlockPos(world, player, depth);
        }
        if (ClaimedChunks.instance != null && ClaimedChunks.instance.getChunk(new ChunkDimPos(x >> 4, z >> 4, world.field_73011_w.field_76574_g)) != null) {
            return this.findBlockPos(world, player, depth);
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        if (biome.field_76791_y.contains("Ocean")) {
            return this.findBlockPos(world, player, depth);
        }
        while (y > 0) {
            Block blockFeet = world.func_147439_a(x, --y, z);
            Block blockHead = world.func_147439_a(x, y + 2, z);
            if (blockFeet.equals(Blocks.field_150350_a) || !blockHead.equals(Blocks.field_150350_a) || UNSAFE_BLOCKS.contains(blockFeet)) continue;
            return TeleporterDimPos.of((double)x + 0.5, (double)y + 2.5, (double)z + 0.5, world.field_73011_w.field_76574_g);
        }
        return this.findBlockPos(world, player, depth);
    }

    private boolean isInsideWorldBorder(World world, double x, double y, double z) {
        return x > -3.0E7 && x < 3.0E7 && z > -3.0E7 && z < 3.0E7 && y > -3.0E7 && y < 3.0E7;
    }
}

