/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client;

import com.gtnewhorizon.gtnhlib.config.Config;
import serverutils.client.EnumNotificationLocation;
import serverutils.client.EnumPlacement;
import serverutils.client.EnumSidebarLocation;
import serverutils.lib.math.Ticks;

@Config(modid="serverutilities", configSubDirectory="../serverutilities/client/")
public class ServerUtilitiesClientConfig {
    @Config.Comment(value={"Show item Ore Dictionary names in inventory."})
    @Config.LangKey(value="serverutilities_client.item_ore_names")
    @Config.DefaultBoolean(value=false)
    public static boolean item_ore_names;
    @Config.Comment(value={"Show item NBT in inventory."})
    @Config.LangKey(value="serverutilities_client.item_nbt")
    @Config.DefaultBoolean(value=false)
    public static boolean item_nbt;
    @Config.Comment(value={"Where to place the sidebar buttons."})
    @Config.LangKey(value="serverutilities_client.sidebar_buttons")
    @Config.DefaultEnum(value="UNLOCKED")
    public static EnumSidebarLocation sidebar_buttons;
    @Config.Comment(value={"Move buttons above potion effect label when sidebar is locked to INVENTORY_SIDE and player has potion effects."})
    @Config.LangKey(value="serverutilities_client.sidebar_buttons_above_potion")
    @Config.DefaultBoolean(value=false)
    public static boolean sidebar_buttons_above_potion;
    @Config.Comment(value={"GROUPED: Buttons are grouped together.\nVERTICAL: Buttons are placed in a vertical line.\nHORIZONTAL: Buttons are placed in a horizontal line."})
    @Config.LangKey(value="serverutilities_client.sidebar_placement")
    @Config.DefaultEnum(value="GROUPED")
    public static EnumPlacement sidebar_placement;
    @Config.Comment(value={"SCREEN: Receive notifications as normal above the hotbar.\nCHAT: Convert all non-important notifications to chat messages.\nDISABLED: Disable non-important notifications entirely."})
    @Config.LangKey(value="serverutilities_client.notification_location")
    @Config.DefaultEnum(value="SCREEN")
    public static EnumNotificationLocation notifications;
    @Config.Comment(value={"Draw dotted lines on loaded chunks to improve noticeability."})
    @Config.LangKey(value="serverutilities_client.show_dotted_lines")
    @Config.DefaultBoolean(value=true)
    public static boolean show_dotted_lines;
    @Config.Comment(value={"Show when server will shut down in corner."})
    @Config.LangKey(value="serverutilities_client.show_shutdown_timer")
    @Config.DefaultBoolean(value=true)
    public static boolean show_shutdown_timer;
    @Config.Comment(value={"When will it start to show the shutdown timer."})
    @Config.LangKey(value="serverutilities_client.shutdown_timer_start")
    @Config.DefaultString(value="1m")
    public static String shutdown_timer_start;
    @Config.DefaultInt(value=6000)
    public static int button_daytime;
    @Config.DefaultInt(value=18000)
    public static int button_nighttime;
    @Config.Ignore
    private static long show_shutdown_timer_ms;

    public static long getShowShutdownTimer() {
        if (show_shutdown_timer_ms == -1L) {
            show_shutdown_timer_ms = Ticks.get(shutdown_timer_start).millis();
        }
        return show_shutdown_timer_ms;
    }

    static {
        show_shutdown_timer_ms = -1L;
    }
}

