/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task.backup;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ClaimedChunks;
import serverutils.lib.data.Universe;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.compression.CommonsCompressor;
import serverutils.lib.util.compression.ICompress;
import serverutils.lib.util.compression.LegacyCompressor;
import serverutils.task.Task;
import serverutils.task.backup.ThreadBackup;

public class BackupTask
extends Task {
    public static final Pattern BACKUP_NAME_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}(.*)");
    public static final File BACKUP_TEMP_FOLDER = new File("serverutilities/temp/");
    private static final boolean useLegacy;
    public static File backupsFolder;
    public static ThreadBackup thread;
    public static boolean hadPlayer;
    private ICommandSender sender;
    private String customName = "";
    private boolean post = false;

    public BackupTask() {
        super(Ticks.HOUR.x(ServerUtilitiesConfig.backups.backup_timer));
    }

    public BackupTask(@Nullable ICommandSender ics, String customName) {
        this.customName = customName;
        this.sender = ics;
    }

    public BackupTask(boolean postCleanup) {
        super(0L);
        this.post = postCleanup;
    }

    @Override
    public boolean isRepeatable() {
        return !this.post;
    }

    @Override
    public void execute(Universe universe) {
        boolean auto;
        if (this.post) {
            this.postBackup(universe);
            return;
        }
        if (thread != null) {
            return;
        }
        boolean bl = auto = this.sender == null;
        if (auto && !ServerUtilitiesConfig.backups.enable_backups) {
            return;
        }
        MinecraftServer server = universe.server;
        if (auto && ServerUtilitiesConfig.backups.need_online_players) {
            if (!this.hasOnlinePlayers(server) && !hadPlayer) {
                return;
            }
            hadPlayer = false;
        }
        ServerUtilitiesNotifications.backupNotification(ServerUtilitiesNotifications.BACKUP_START, "cmd.backup_start", new Object[0]);
        try {
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                worldserver.field_73058_d = true;
                worldserver.func_73044_a(true, null);
            }
        }
        catch (Exception ex) {
            ServerUtilities.LOGGER.info("An error occurred while turning off auto-save.", (Throwable)ex);
        }
        File worldDir = DimensionManager.getCurrentSaveRootDirectory();
        HashSet<ChunkDimPos> backupChunks = new HashSet<ChunkDimPos>();
        if (ServerUtilitiesConfig.backups.only_backup_claimed_chunks && ClaimedChunks.isActive()) {
            backupChunks.addAll(ClaimedChunks.instance.getAllClaimedPositions());
            BACKUP_TEMP_FOLDER.mkdirs();
        }
        ICompress compressor = useLegacy ? new LegacyCompressor() : new CommonsCompressor();
        if (ServerUtilitiesConfig.backups.use_separate_thread) {
            thread = new ThreadBackup(compressor, worldDir, this.customName, backupChunks);
            thread.start();
        } else {
            ThreadBackup.doBackup(compressor, worldDir, this.customName, backupChunks);
        }
        universe.scheduleTask(new BackupTask(true));
    }

    public static void clearOldBackups() {
        File[] files = backupsFolder.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        List<File> backupFiles = Arrays.stream(files).filter(file -> ServerUtilitiesConfig.backups.delete_custom_name_backups || BACKUP_NAME_PATTERN.matcher(file.getName()).matches()).sorted(Comparator.comparingLong(File::lastModified)).collect(Collectors.toList());
        int maxGb = ServerUtilitiesConfig.backups.max_folder_size;
        if (maxGb > 0) {
            long currentSize = backupFiles.stream().mapToLong(file -> FileUtils.getSize(file, FileUtils.SizeUnit.GB)).sum();
            if (currentSize <= (long)maxGb) {
                return;
            }
            BackupTask.deleteOldBackups(backupFiles, currentSize, maxGb);
        } else if (backupFiles.size() > ServerUtilitiesConfig.backups.backups_to_keep) {
            BackupTask.deleteExcessBackups(backupFiles);
        }
    }

    private static void deleteOldBackups(List<File> backupFiles, long currentSize, int maxGb) {
        int deleted = 0;
        for (File file : backupFiles) {
            if (currentSize <= (long)maxGb) break;
            currentSize -= FileUtils.getSize(file, FileUtils.SizeUnit.GB);
            ServerUtilities.LOGGER.info("Deleting old backup: {}", new Object[]{file.getPath()});
            FileUtils.delete(file);
            ++deleted;
        }
        ServerUtilities.LOGGER.info("Deleted {} old backups", new Object[]{deleted});
    }

    private static void deleteExcessBackups(List<File> backupFiles) {
        int toDelete = backupFiles.size() - ServerUtilitiesConfig.backups.backups_to_keep;
        ServerUtilities.LOGGER.info("Deleting {} old backups", new Object[]{toDelete});
        for (int i = 0; i < toDelete; ++i) {
            File file = backupFiles.get(i);
            ServerUtilities.LOGGER.info("Deleted old backup: {}", new Object[]{file.getPath()});
            FileUtils.delete(file);
        }
    }

    private boolean hasOnlinePlayers(MinecraftServer server) {
        return !server.func_71203_ab().field_72404_b.isEmpty();
    }

    private void postBackup(Universe universe) {
        if (thread != null && !BackupTask.thread.isDone) {
            this.setNextTime(System.currentTimeMillis() + Ticks.SECOND.millis());
            universe.scheduleTask(this);
            return;
        }
        BackupTask.clearOldBackups();
        FileUtils.delete(BACKUP_TEMP_FOLDER);
        thread = null;
        try {
            MinecraftServer server = ServerUtils.getServer();
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                if (!worldserver.field_73058_d) continue;
                worldserver.field_73058_d = false;
            }
        }
        catch (Exception ex) {
            ServerUtilities.LOGGER.info("An error occurred while turning on auto-save.", (Throwable)ex);
        }
    }

    static {
        hadPlayer = false;
        File file = backupsFolder = ServerUtilitiesConfig.backups.backup_folder_path.isEmpty() ? new File("/backups/") : new File(ServerUtilitiesConfig.backups.backup_folder_path);
        if (!backupsFolder.exists()) {
            backupsFolder.mkdirs();
        }
        BackupTask.clearOldBackups();
        ServerUtilities.LOGGER.info("Backups folder - {}", new Object[]{backupsFolder.getAbsolutePath()});
        useLegacy = !CommonUtils.getClassExists("org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream");
    }
}

