/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.ThreadedFileIOBase;
import serverutils.lib.ATHelper;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.ChatComponentScore;
import serverutils.lib.util.text_components.Notification;
import serverutils.lib.util.text_components.TextComponentCountdown;

public class JsonUtils {
    public static final JsonPrimitive JSON_TRUE = new JsonPrimitive(Boolean.valueOf(true));
    public static final JsonPrimitive JSON_FALSE = new JsonPrimitive(Boolean.valueOf(false));
    public static final JsonPrimitive JSON_EMPTY_STRING = new JsonPrimitive("");
    public static final JsonPrimitive JSON_ZERO = new JsonPrimitive((Number)0);

    public static boolean isNull(@Nullable JsonElement element) {
        return element == null || element == JsonNull.INSTANCE || element.isJsonNull();
    }

    public static JsonElement nonnull(@Nullable JsonElement json) {
        return JsonUtils.isNull(json) ? JsonNull.INSTANCE : json;
    }

    public static JsonElement parse(@Nullable Reader reader) throws Exception {
        if (reader == null) {
            return JsonNull.INSTANCE;
        }
        JsonReader jsonReader = new JsonReader(reader);
        boolean lenient = jsonReader.isLenient();
        jsonReader.setLenient(true);
        JsonElement element = Streams.parse((JsonReader)jsonReader);
        if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
            throw new JsonSyntaxException("Did not consume the entire document.");
        }
        return element;
    }

    public static void toJson(Writer writer, @Nullable JsonElement element, boolean prettyPrinting) {
        if (JsonUtils.isNull(element)) {
            try {
                writer.write("null");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setLenient(true);
        jsonWriter.setHtmlSafe(false);
        jsonWriter.setSerializeNulls(true);
        if (prettyPrinting) {
            jsonWriter.setIndent("\t");
        }
        try {
            Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
        }
        catch (Exception ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    public static String toJson(@Nullable JsonElement element, boolean prettyPrinting) {
        StringWriter writer = new StringWriter();
        JsonUtils.toJson(writer, element, prettyPrinting);
        return writer.toString();
    }

    public static void toJson(File file, @Nullable JsonElement element, boolean prettyPrinting) {
        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.newFile(file)), StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(output);){
            JsonUtils.toJson(writer, element, prettyPrinting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toJson(@Nullable JsonElement element) {
        return JsonUtils.toJson(element, false);
    }

    public static void toJson(File file, @Nullable JsonElement element) {
        JsonUtils.toJson(file, element, true);
    }

    public static void toJsonSafe(File file, @Nullable JsonElement element) {
        ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
            JsonUtils.toJson(file, element);
            return false;
        });
    }

    public static JsonArray toArray(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        JsonArray array = new JsonArray();
        if (!element.isJsonNull()) {
            array.add(element);
        }
        return array;
    }

    public static JsonElement serializeTextComponent(@Nullable IChatComponent component) {
        if (component == null) {
            return JsonNull.INSTANCE;
        }
        if (component.getClass() == ChatComponentText.class && component.func_150253_a().isEmpty() && component.func_150256_b().func_150229_g()) {
            return new JsonPrimitive(((ChatComponentText)component).func_150265_g());
        }
        JsonObject json = new JsonObject();
        ChatStyle style = component.func_150256_b();
        if (!style.func_150229_g()) {
            if (ATHelper.getBold(style) != null) {
                json.addProperty("bold", Boolean.valueOf(style.func_150223_b()));
            }
            if (ATHelper.getItalic(style) != null) {
                json.addProperty("italic", Boolean.valueOf(style.func_150242_c()));
            }
            if (ATHelper.getUnderlined(style) != null) {
                json.addProperty("underlined", Boolean.valueOf(style.func_150234_e()));
            }
            if (ATHelper.getStrikethrough(style) != null) {
                json.addProperty("strikethrough", Boolean.valueOf(style.func_150236_d()));
            }
            if (ATHelper.getObfuscated(style) != null) {
                json.addProperty("obfuscated", Boolean.valueOf(style.func_150233_f()));
            }
            if (ATHelper.getColor(style) != null) {
                json.addProperty("color", style.func_150215_a().func_96297_d());
            }
            if (ATHelper.getClickEvent(style) != null) {
                json.add("clickEvent", JsonUtils.serializeClickEvent(style.func_150235_h()));
            }
            if (ATHelper.getHoverEvent(style) != null) {
                json.add("hoverEvent", JsonUtils.serializeHoverEvent(style.func_150210_i()));
            }
        }
        if (!component.func_150253_a().isEmpty()) {
            JsonArray array = new JsonArray();
            for (IChatComponent IChatComponent2 : component.func_150253_a()) {
                array.add(JsonUtils.serializeTextComponent(IChatComponent2));
            }
            json.add("extra", (JsonElement)array);
        }
        if (component instanceof ChatComponentText) {
            ChatComponentText text = (ChatComponentText)component;
            json.addProperty("text", text.func_150265_g());
            if (component instanceof Notification) {
                Notification n = (Notification)component;
                if (!n.getId().equals((Object)Notification.VANILLA_STATUS)) {
                    json.addProperty("notification", n.getId().toString());
                }
                if (n.getTimer().ticks() != 60L) {
                    json.addProperty("timer", n.getTimer().toString());
                }
                if (n.isImportant()) {
                    json.addProperty("important", Boolean.valueOf(true));
                }
                if (n.isVanilla()) {
                    json.addProperty("vanilla", Boolean.valueOf(true));
                }
            }
        } else if (component instanceof ChatComponentTranslation) {
            ChatComponentTranslation translation = (ChatComponentTranslation)component;
            json.addProperty("translate", translation.func_150268_i());
            if (translation.func_150271_j().length > 0) {
                JsonArray array = new JsonArray();
                for (Object object : translation.func_150271_j()) {
                    if (object instanceof IChatComponent) {
                        array.add(JsonUtils.serializeTextComponent((IChatComponent)object));
                        continue;
                    }
                    array.add((JsonElement)new JsonPrimitive(String.valueOf(object)));
                }
                json.add("with", (JsonElement)array);
            }
        }
        if (json.entrySet().isEmpty()) {
            throw new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
        }
        return json;
    }

    @Nullable
    public static IChatComponent deserializeTextComponent(@Nullable JsonElement element) {
        Object component;
        String s;
        if (JsonUtils.isNull(element)) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            return new ChatComponentText(StringUtils.fixTabs(element.getAsString(), 2));
        }
        if (!element.isJsonObject()) {
            if (!element.isJsonArray()) {
                throw new JsonParseException("Don't know how to turn " + element + " into a Component");
            }
            IChatComponent component2 = null;
            for (JsonElement element1 : element.getAsJsonArray()) {
                IChatComponent component1 = JsonUtils.deserializeTextComponent(element1);
                if (component1 == null) {
                    component1 = new ChatComponentText("");
                }
                if (component2 == null) {
                    component2 = component1;
                    continue;
                }
                component2.func_150257_a(component1);
            }
            return component2;
        }
        JsonObject json = element.getAsJsonObject();
        if (json.has("text") || json.has("notification")) {
            String string = s = json.has("text") ? StringUtils.fixTabs(json.get("text").getAsString(), 2) : "";
            if (json.has("notification") || json.has("timer") || json.has("important") || json.has("vanilla")) {
                Notification n;
                component = n = Notification.of(json.has("notification") ? new ResourceLocation(json.get("notification").getAsString()) : Notification.VANILLA_STATUS, s, new IChatComponent[0]);
                if (json.has("timer")) {
                    JsonElement e = json.get("timer");
                    if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                        n.setTimer(Ticks.get(e.getAsLong()));
                    } else {
                        n.setTimer(Ticks.get(e.getAsString()));
                    }
                }
                if (json.has("important")) {
                    n.setImportant(net.minecraft.util.JsonUtils.func_151212_i((JsonObject)json, (String)"important"));
                }
                if (json.has("vanilla")) {
                    n.setVanilla(net.minecraft.util.JsonUtils.func_151212_i((JsonObject)json, (String)"vanilla"));
                }
            } else {
                component = json.has("countdown") ? new TextComponentCountdown(s, json.get("countdown").getAsLong()) : new ChatComponentText(s);
            }
        } else if (json.has("translate")) {
            s = json.get("translate").getAsString();
            if (json.has("with")) {
                JsonArray a = json.getAsJsonArray("with");
                Object[] o1 = new Object[a.size()];
                for (int i = 0; i < o1.length; ++i) {
                    ChatComponentText t2;
                    o1[i] = JsonUtils.deserializeTextComponent(a.get(i));
                    if (o1[i] == null || o1[i].getClass() != ChatComponentText.class || !(t2 = (ChatComponentText)o1[i]).func_150256_b().func_150229_g() || !t2.func_150253_a().isEmpty()) continue;
                    o1[i] = t2.func_150265_g();
                }
                component = new ChatComponentTranslation(s, o1);
            } else {
                component = new ChatComponentTranslation(s, new Object[0]);
            }
        } else if (json.has("score")) {
            JsonObject o1 = json.getAsJsonObject("score");
            if (!o1.has("name") || !o1.has("objective")) {
                throw new JsonParseException("A score component needs a least a name and an objective");
            }
            component = new ChatComponentScore(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"name"), net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"objective"));
            if (o1.has("value")) {
                ((ChatComponentScore)((Object)component)).setValue(net.minecraft.util.JsonUtils.func_151200_h((JsonObject)o1, (String)"value"));
            }
        } else {
            return null;
        }
        if (json.has("extra")) {
            JsonArray a = json.getAsJsonArray("extra");
            if (a.size() <= 0) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (JsonElement element1 : a) {
                IChatComponent component1 = JsonUtils.deserializeTextComponent(element1);
                component.func_150257_a((IChatComponent)(component1 == null ? new ChatComponentText("") : component1));
            }
        }
        ChatStyle style = new ChatStyle();
        if (json.has("bold")) {
            style.func_150227_a(Boolean.valueOf(json.get("bold").getAsBoolean()));
        }
        if (json.has("italic")) {
            style.func_150217_b(Boolean.valueOf(json.get("italic").getAsBoolean()));
        }
        if (json.has("underlined")) {
            style.func_150228_d(Boolean.valueOf(json.get("underlined").getAsBoolean()));
        }
        if (json.has("strikethrough")) {
            style.func_150225_c(Boolean.valueOf(json.get("strikethrough").getAsBoolean()));
        }
        if (json.has("obfuscated")) {
            style.func_150237_e(Boolean.valueOf(json.get("obfuscated").getAsBoolean()));
        }
        if (json.has("color")) {
            style.func_150238_a(EnumChatFormatting.func_96300_b((String)json.get("color").getAsString()));
        }
        if (json.has("clickEvent")) {
            style.func_150241_a(JsonUtils.deserializeClickEvent(json.get("clickEvent")));
        }
        if (json.has("hoverEvent")) {
            style.func_150209_a(JsonUtils.deserializeHoverEvent(json.get("hoverEvent")));
        }
        component.func_150255_a(style);
        return component;
    }

    public static JsonElement serializeClickEvent(@Nullable ClickEvent event) {
        if (event == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", event.func_150669_a().func_150673_b());
        o.addProperty("value", event.func_150668_b());
        return o;
    }

    @Nullable
    public static ClickEvent deserializeClickEvent(JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            return new ClickEvent(ClickEvent.Action.OPEN_URL, element.getAsString());
        }
        JsonObject o = element.getAsJsonObject();
        if (o != null) {
            String s;
            JsonPrimitive a = o.getAsJsonPrimitive("action");
            ClickEvent.Action action = a == null ? null : ClickEvent.Action.func_150672_a((String)a.getAsString());
            JsonPrimitive v = o.getAsJsonPrimitive("value");
            String string = s = v == null ? null : v.getAsString();
            if (action != null && s != null && action.func_150674_a()) {
                return new ClickEvent(action, s);
            }
        }
        return null;
    }

    public static JsonElement serializeHoverEvent(@Nullable HoverEvent event) {
        if (event == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject o = new JsonObject();
        o.addProperty("action", event.func_150701_a().func_150685_b());
        o.add("value", JsonUtils.serializeTextComponent(event.func_150702_b()));
        return o;
    }

    @Nullable
    public static HoverEvent deserializeHoverEvent(@Nullable JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        JsonObject o = element.getAsJsonObject();
        if (o != null) {
            JsonPrimitive a = o.getAsJsonPrimitive("action");
            HoverEvent.Action action = a == null ? null : HoverEvent.Action.func_150684_a((String)a.getAsString());
            IChatComponent t = JsonUtils.deserializeTextComponent(o.get("value"));
            if (action != null && t != null && action.func_150686_a()) {
                return new HoverEvent(action, t);
            }
        }
        return null;
    }

    public static JsonObject fromJsonTree(JsonObject o) {
        JsonObject map = new JsonObject();
        JsonUtils.fromJsonTree0(map, null, o);
        return map;
    }

    private static void fromJsonTree0(JsonObject map, @Nullable String id0, JsonObject o) {
        for (Map.Entry entry : o.entrySet()) {
            if (entry.getValue() instanceof JsonObject) {
                JsonUtils.fromJsonTree0(map, id0 == null ? (String)entry.getKey() : id0 + '.' + (String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
                continue;
            }
            map.add(id0 == null ? (String)entry.getKey() : id0 + '.' + (String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static JsonObject toJsonTree(Collection<Map.Entry<String, JsonElement>> tree) {
        JsonObject o1 = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : tree) {
            JsonUtils.findGroup(o1, entry.getKey()).add(JsonUtils.lastKeyPart(entry.getKey()), entry.getValue());
        }
        return o1;
    }

    private static String lastKeyPart(String s) {
        int idx = s.lastIndexOf(46);
        if (idx != -1) {
            return s.substring(idx + 1);
        }
        return s;
    }

    private static JsonObject findGroup(JsonObject parent, String s) {
        int idx = s.indexOf(46);
        if (idx != -1) {
            String s0 = s.substring(0, idx);
            JsonElement o = parent.get(s0);
            if (o == null) {
                o = new JsonObject();
                parent.add(s0, o);
            }
            return JsonUtils.findGroup(o.getAsJsonObject(), s.substring(idx + 1, s.length() - 1));
        }
        return parent;
    }

    public static String fixJsonString(String json) {
        if (json.isEmpty()) {
            return "\"\"";
        }
        if (!(json.indexOf(32) == -1 || json.startsWith("\"") && json.endsWith("\"") || json.startsWith("{") && json.endsWith("}") || json.startsWith("[") && json.endsWith("]"))) {
            json = "\"" + json + "\"";
        }
        return json;
    }

    public static JsonElement toJson(@Nullable NBTBase nbt) {
        if (nbt == null) {
            return JsonNull.INSTANCE;
        }
        switch (nbt.func_74732_a()) {
            case 10: {
                NBTTagCompound tagCompound = (NBTTagCompound)nbt;
                JsonObject json = new JsonObject();
                if (!tagCompound.func_82582_d()) {
                    for (String s : tagCompound.func_150296_c()) {
                        json.add(s, JsonUtils.toJson(tagCompound.func_74781_a(s)));
                    }
                }
                return json;
            }
            case 9: {
                JsonArray json = new JsonArray();
                NBTTagList list = (NBTTagList)nbt;
                if (list.func_74745_c() != 0) {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        json.add(JsonUtils.toJson((NBTBase)list.field_74747_a.get(i)));
                    }
                }
                return json;
            }
            case 8: {
                String s = ((NBTTagString)nbt).func_150285_a_();
                return s.isEmpty() ? JSON_EMPTY_STRING : new JsonPrimitive(s);
            }
            case 1: {
                return new JsonPrimitive((Number)((NBTTagByte)nbt).func_150290_f());
            }
            case 2: {
                return new JsonPrimitive((Number)((NBTTagShort)nbt).func_150289_e());
            }
            case 3: {
                return new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d());
            }
            case 4: {
                return new JsonPrimitive((Number)((NBTTagLong)nbt).func_150291_c());
            }
            case 5: {
                return new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h()));
            }
            case 6: {
                return new JsonPrimitive((Number)((NBTTagDouble)nbt).func_150286_g());
            }
            case 7: {
                JsonArray json = new JsonArray();
                NBTTagByteArray ba = (NBTTagByteArray)nbt;
                if (ba.func_150292_c().length != 0) {
                    for (byte v : ba.func_150292_c()) {
                        json.add((JsonElement)new JsonPrimitive((Number)v));
                    }
                }
                return json;
            }
            case 11: {
                JsonArray json = new JsonArray();
                NBTTagIntArray ia = (NBTTagIntArray)nbt;
                if (ia.func_150302_c().length != 0) {
                    for (int v : ia.func_150302_c()) {
                        json.add((JsonElement)new JsonPrimitive((Number)v));
                    }
                }
                return json;
            }
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public static NBTBase toNBT(@Nullable JsonElement element) {
        if (JsonUtils.isNull(element)) {
            return null;
        }
        try {
            return JsonToNBT.func_150315_a((String)JsonUtils.toJson(element));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static JsonElement copy(JsonElement json) {
        if (JsonUtils.isNull(json)) {
            return JsonNull.INSTANCE;
        }
        if (json.isJsonObject()) {
            JsonObject json1 = new JsonObject();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                json1.add((String)entry.getKey(), JsonUtils.copy((JsonElement)entry.getValue()));
            }
            return json1;
        }
        if (json.isJsonArray()) {
            JsonArray json1 = new JsonArray();
            for (JsonElement element : json.getAsJsonArray()) {
                json1.add(JsonUtils.copy(element));
            }
            return json1;
        }
        return json;
    }

    public static JsonElement fromJson(Reader json) {
        return json == null ? JsonNull.INSTANCE : new JsonParser().parse(json);
    }

    public static JsonElement fromJson(File json) {
        try {
            if (json == null || !json.exists()) {
                return JsonNull.INSTANCE;
            }
            BufferedReader reader = new BufferedReader(new FileReader(json));
            JsonElement e = JsonUtils.fromJson(reader);
            reader.close();
            return e;
        }
        catch (Exception exception) {
            return JsonNull.INSTANCE;
        }
    }

    public static void copy(JsonObject from, JsonObject to) {
        for (Map.Entry entry : from.entrySet()) {
            to.add((String)entry.getKey(), JsonUtils.copy((JsonElement)entry.getValue()));
        }
    }
}

