/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.icon;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import serverutils.ServerUtilitiesConfig;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.icon.Icon;
import serverutils.lib.item.ItemStackSerializer;
import serverutils.lib.util.InvUtils;

public class ItemIcon
extends Icon {
    ItemStack stack;

    public static Icon getItemIcon(ItemStack stack) {
        return stack == null ? EMPTY : new ItemIcon(stack);
    }

    public static Icon getItemIcon(Item item) {
        return ItemIcon.getItemIcon(new ItemStack(item));
    }

    public static Icon getItemIcon(Block block) {
        return ItemIcon.getItemIcon(new ItemStack(block));
    }

    public static Icon getItemIcon(String lazyStackString) {
        return lazyStackString.isEmpty() ? EMPTY : new LazyItemIcon(lazyStackString);
    }

    private ItemIcon(ItemStack is) {
        this.stack = is;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, true);
        GuiHelper.setupDrawing();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawStatic(int x, int y, int w, int h) {
        GuiHelper.drawItem(this.getStack(), x, y, (double)w / 16.0, (double)h / 16.0, false);
        GuiHelper.setupDrawing();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawItem3D(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.pushMatrix();
        GlStateManager.scale(1.0f, -1.0f, -0.02f);
        ItemRenderer renderer = new ItemRenderer(mc);
        renderer.renderItem((EntityLivingBase)mc.field_71439_g, stack, 0, IItemRenderer.ItemRenderType.ENTITY);
        GlStateManager.popMatrix();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw3D() {
        ItemIcon.drawItem3D(this.getStack());
    }

    public String toString() {
        return "item:" + ItemStackSerializer.toString(this.getStack());
    }

    @Override
    public int hashCode() {
        ItemStack stack = this.getStack();
        int h = stack.func_77973_b().hashCode();
        h = h * 31 + stack.field_77994_a;
        h = h * 31 + stack.func_77960_j();
        h = h * 31 + Objects.hashCode(stack.func_77978_p());
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof ItemIcon && ItemStack.func_77970_a((ItemStack)this.getStack(), (ItemStack)((ItemIcon)o).getStack());
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.getStack();
    }

    private static class LazyItemIcon
    extends ItemIcon {
        private String lazyStackString;
        private boolean createdStack;

        private LazyItemIcon(String s) {
            super(InvUtils.EMPTY_STACK);
            this.lazyStackString = s;
        }

        @Override
        public ItemStack getStack() {
            if (!this.createdStack) {
                this.stack = ItemStackSerializer.parseItem(this.lazyStackString);
                this.createdStack = true;
                if (ServerUtilitiesConfig.debugging.print_more_errors && this.stack == null) {
                    this.stack = InvUtils.brokenItem(this.lazyStackString);
                }
            }
            return this.stack;
        }

        @Override
        public String toString() {
            return "item:" + this.lazyStackString;
        }
    }
}

