/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import java.util.function.Predicate;
import net.minecraft.event.ClickEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.data.Action;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.data.TeamAction;
import serverutils.lib.gui.GuiIcons;
import serverutils.net.MessageMyTeamPlayerList;

public class ServerUtilitiesTeamGuiActions {
    private static final Predicate<EnumTeamStatus> NO_ENEMIES_PREDICATE = status -> status != EnumTeamStatus.ENEMY;
    private static final Predicate<EnumTeamStatus> MEMBERS_PREDICATE = status -> status.isEqualOrGreaterThan(EnumTeamStatus.MEMBER);
    private static final Predicate<EnumTeamStatus> ALLIES_PREDICATE = MEMBERS_PREDICATE.negate().and(NO_ENEMIES_PREDICATE);
    private static final Predicate<EnumTeamStatus> ENEMIES_PREDICATE = status -> status == EnumTeamStatus.ENEMY || status == EnumTeamStatus.NONE;
    public static final TeamAction CONFIG = new TeamAction("serverutilities", "config", GuiIcons.SETTINGS, -100){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return player.team.isModerator(player) ? Action.Type.ENABLED : Action.Type.DISABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            ServerUtilitiesAPI.editServerConfig(player.getPlayer(), player.team.getSettings(), player.team);
        }
    }.setTitle((IChatComponent)new ChatComponentTranslation("gui.settings", new Object[0]));
    public static final TeamAction INFO = new TeamAction("serverutilities", "info", GuiIcons.INFO, 0){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return Action.Type.INVISIBLE;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
        }
    }.setTitle((IChatComponent)new ChatComponentTranslation("gui.info", new Object[0]));
    public static final TeamAction MEMBERS = new TeamAction("serverutilities", "members", GuiIcons.FRIENDS, 30){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return player.team.isModerator(player) && player.team.universe.getPlayers().size() > 1 ? Action.Type.ENABLED : Action.Type.DISABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            if (data.func_82582_d()) {
                new MessageMyTeamPlayerList(this.getId(), player, NO_ENEMIES_PREDICATE).sendTo(player.getPlayer());
                return;
            }
            ForgePlayer p = player.team.universe.getPlayer(data.func_74779_i("player"));
            if (p == null || p == player) {
                return;
            }
            switch (data.func_74779_i("action")) {
                case "kick": {
                    if (!player.team.isMember(p)) break;
                    player.team.removeMember(p);
                    player.team.setRequestingInvite(p, true);
                    break;
                }
                case "invite": {
                    player.team.setStatus(p, EnumTeamStatus.INVITED);
                    if (player.team.isRequestingInvite(p)) {
                        if (p.hasTeam()) {
                            player.team.setRequestingInvite(p, false);
                            break;
                        }
                        player.team.addMember(p, false);
                        break;
                    }
                    if (!p.isOnline()) break;
                    ChatComponentTranslation component = new ChatComponentTranslation("serverutilities.lang.team.invited_you", new Object[]{player.team, player.getDisplayName()});
                    component.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team join " + player.team.getId()));
                    p.getPlayer().func_146105_b((IChatComponent)component);
                    break;
                }
                case "cancel_invite": {
                    if (player.team.getHighestStatus(p) != EnumTeamStatus.INVITED) break;
                    player.team.setStatus(p, EnumTeamStatus.NONE);
                    break;
                }
                case "deny_request": {
                    player.team.setRequestingInvite(p, false);
                }
            }
        }
    };
    public static final TeamAction ALLIES = new TeamAction("serverutilities", "allies", GuiIcons.STAR, 40){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return player.team.isModerator(player) && player.team.universe.getPlayers().size() > 1 ? Action.Type.ENABLED : Action.Type.DISABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            ForgePlayer p;
            if (data.func_82582_d()) {
                new MessageMyTeamPlayerList(this.getId(), player, ALLIES_PREDICATE).sendTo(player.getPlayer());
            }
            if ((p = player.team.universe.getPlayer(data.func_74779_i("player"))) != null && p != player) {
                player.team.setStatus(p, data.func_74767_n("add") ? EnumTeamStatus.ALLY : EnumTeamStatus.NONE);
            }
        }
    };
    public static final TeamAction MODERATORS = new TeamAction("serverutilities", "moderators", GuiIcons.SHIELD, 50){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return player.team.isOwner(player) && player.team.getMembers().size() > 1 ? Action.Type.ENABLED : Action.Type.DISABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            if (data.func_82582_d()) {
                new MessageMyTeamPlayerList(this.getId(), player, MEMBERS_PREDICATE).sendTo(player.getPlayer());
                return;
            }
            ForgePlayer p = player.team.universe.getPlayer(data.func_74779_i("player"));
            if (p != null && p != player) {
                player.team.setStatus(p, data.func_74767_n("add") ? EnumTeamStatus.MOD : EnumTeamStatus.NONE);
            }
        }
    };
    public static final TeamAction ENEMIES = new TeamAction("serverutilities", "enemies", GuiIcons.CLOSE, 60){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return player.team.isModerator(player) && player.team.universe.getPlayers().size() > 1 ? Action.Type.ENABLED : Action.Type.DISABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            ForgePlayer p;
            if (data.func_82582_d()) {
                new MessageMyTeamPlayerList(this.getId(), player, ENEMIES_PREDICATE).sendTo(player.getPlayer());
            }
            if ((p = player.team.universe.getPlayer(data.func_74779_i("player"))) != null && p != player) {
                player.team.setStatus(p, data.func_74767_n("add") ? EnumTeamStatus.ENEMY : EnumTeamStatus.NONE);
            }
        }
    };
    public static final TeamAction LEAVE = new TeamAction("serverutilities", "leave", GuiIcons.REMOVE, 10000){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return !player.team.isOwner(player) || player.team.getMembers().size() <= 1 ? Action.Type.ENABLED : Action.Type.INVISIBLE;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            player.team.removeMember(player);
            ServerUtilitiesAPI.sendCloseGuiPacket(player.getPlayer());
        }
    }.setRequiresConfirm();
    public static final TeamAction TRANSFER_OWNERSHIP = new TeamAction("serverutilities", "transfer_ownership", GuiIcons.RIGHT, 10000){

        @Override
        public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
            return !player.team.isOwner(player) || player.team.getMembers().size() <= 1 ? Action.Type.INVISIBLE : Action.Type.ENABLED;
        }

        @Override
        public void onAction(ForgePlayer player, NBTTagCompound data) {
            ForgePlayer p;
            if (data.func_82582_d()) {
                new MessageMyTeamPlayerList(this.getId(), player, MEMBERS_PREDICATE).sendTo(player.getPlayer());
            }
            if ((p = player.team.universe.getPlayer(data.func_74779_i("player"))) != null && p != player) {
                player.team.setStatus(p, EnumTeamStatus.OWNER);
            }
        }
    };
}

