/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.ranks;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigValue;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;
import serverutils.ranks.ServerUtilitiesPermissionHandler;

public class CmdGetPermission
extends CmdBase {
    public CmdGetPermission() {
        super("get_permission", CmdBase.Level.OP);
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("getp");
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return Ranks.matchPossibleNodes(args[args.length - 1], Ranks.isActive() ? Ranks.INSTANCE.getPermissionNodes() : ServerUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes());
        }
        return super.func_71516_a(sender, args);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        IChatComponent valueText;
        this.checkArgs(sender, args, 2);
        Rank rank = Ranks.INSTANCE.getRank(sender, args[0]);
        ConfigValue value = rank.getPermissionValue(args[1], args[1], true);
        if (value.isNull()) {
            valueText = ServerUtilities.lang(sender, "commands.ranks.none", new Object[0]);
            valueText.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GRAY);
        } else if (value instanceof ConfigBoolean) {
            valueText = new ChatComponentText(value.getString());
            valueText.func_150256_b().func_150238_a(value.getBoolean() ? EnumChatFormatting.GREEN : EnumChatFormatting.RED);
        } else {
            valueText = new ChatComponentText(value.getString());
            valueText.func_150256_b().func_150238_a(EnumChatFormatting.BLUE);
        }
        ChatComponentText nodeText = new ChatComponentText(args[1]);
        nodeText.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
        IChatComponent nameText = rank.getDisplayName().func_150259_f();
        nameText.func_150256_b().func_150238_a(EnumChatFormatting.DARK_GREEN);
        sender.func_145747_a(ServerUtilities.lang(sender, "commands.ranks.get_permission.text", nodeText, nameText, valueText));
    }
}

