/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.vp;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.ChunkCoordIntPair;
import org.lwjgl.input.Keyboard;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.lib.EnumTeamColor;
import serverutils.lib.math.ChunkDimPos;
import serverutils.net.MessageClaimedChunksModify;
import serverutils.net.MessageJourneyMapRequest;

public class VPClaimsLocation
implements IWaypointAndLocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private final String teamName;
    private final boolean loaded;
    private final boolean ally;
    private final boolean member;
    private final EnumTeamColor color;

    public VPClaimsLocation(ChunkDimPos chunk, ClientClaimedChunks.ChunkData data) {
        this.blockX = Utils.coordChunkToBlock((int)chunk.posX);
        this.blockZ = Utils.coordChunkToBlock((int)chunk.posZ);
        this.dimensionId = chunk.dim;
        this.teamName = data.team.nameComponent.func_150260_c();
        this.loaded = data.isLoaded();
        this.color = data.team.color;
        this.ally = data.team.isAlly;
        this.member = data.team.isMember;
    }

    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getTeamName() {
        return this.color.getEnumChatFormatting() + this.teamName;
    }

    public EnumTeamColor getTeamColor() {
        return this.color;
    }

    public boolean getOwnTeam() {
        return this.member;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String loadedHint() {
        return this.isLoaded() ? EnumChatFormatting.GREEN + I18n.func_135052_a((String)"serverutilities.lang.chunks.chunk_loaded", (Object[])new Object[0]) : "";
    }

    public String teamHint() {
        if (this.member) {
            return EnumChatFormatting.DARK_AQUA + I18n.func_135052_a((String)"serverutilities.jm.own_team", (Object[])new Object[0]);
        }
        if (this.ally) {
            return EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"serverutilities.lang.team_status.ally", (Object[])new Object[0]);
        }
        return "";
    }

    public String claimHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.claim", (Object[])new Object[0]);
    }

    public String toggleLoadHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.load_hint", (Object[])new Object[0]);
    }

    public String unclaimHint() {
        return EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"serverutilities.jm.unclaim_hint", (Object[])new Object[]{Keyboard.getKeyName((int)VP.keyAction.func_151463_i())});
    }

    public void toggleLoaded() {
        int selectionMode = this.isLoaded() ? 3 : 2;
        Set<ChunkCoordIntPair> chunks = Collections.singleton(new ChunkCoordIntPair(Utils.coordBlockToChunk((int)this.blockX), Utils.coordBlockToChunk((int)this.blockZ)));
        new MessageClaimedChunksModify(Utils.coordBlockToChunk((int)this.blockX), Utils.coordBlockToChunk((int)this.blockZ), selectionMode, chunks).sendToServer();
        new MessageJourneyMapRequest(this.blockX, this.blockX, this.blockZ, this.blockZ).sendToServer();
    }

    public void removeClaim() {
        int selectionMode = 1;
        Set<ChunkCoordIntPair> chunks = Collections.singleton(new ChunkCoordIntPair(Utils.coordBlockToChunk((int)this.blockX), Utils.coordBlockToChunk((int)this.blockZ)));
        new MessageClaimedChunksModify(Utils.coordBlockToChunk((int)this.blockX), Utils.coordBlockToChunk((int)this.blockZ), selectionMode, chunks).sendToServer();
        new MessageJourneyMapRequest(this.blockX, this.blockX, this.blockZ, this.blockZ).sendToServer();
    }

    public Waypoint toWaypoint() {
        this.toggleLoaded();
        return null;
    }

    public boolean isActiveAsWaypoint() {
        return false;
    }

    public void onWaypointCleared() {
    }

    public void onWaypointUpdated(Waypoint waypoint) {
    }
}

