/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.MinecraftForge;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.backups.Backups;
import serverutils.data.BlockDimPosStorage;
import serverutils.data.ClaimedChunks;
import serverutils.data.ServerUtilitiesLoadedChunkManager;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.ServerUtilitiesTeamData;
import serverutils.events.team.ForgeTeamDataEvent;
import serverutils.events.universe.UniverseClosedEvent;
import serverutils.events.universe.UniverseLoadedEvent;
import serverutils.events.universe.UniverseSavedEvent;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataReader;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.math.MathUtils;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.misc.TimeType;
import serverutils.lib.util.text_components.Notification;
import serverutils.ranks.Ranks;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntArrayList;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntComparator;
import serverutils.shadow.it.unimi.dsi.fastutil.ints.IntListIterator;

public class ServerUtilitiesUniverseData {
    public static final ServerUtilitiesUniverseData INST = new ServerUtilitiesUniverseData();
    private static final String BADGE_URL = "https://badges.latmod.com/get?id=";
    private static final ResourceLocation RESTART_TIMER_ID = new ResourceLocation("serverutilities", "restart_timer");
    private static final Map<UUID, String> BADGE_CACHE = new HashMap<UUID, String>();
    public static long shutdownTime;
    public static final BlockDimPosStorage WARPS;
    private static final List<String> worldLog;
    private static final List<String> chatLog;

    public static boolean isInSpawn(MinecraftServer server, ChunkDimPos pos) {
        if (pos.dim != 0 || !server.func_71262_S() && !ServerUtilitiesConfig.world.spawn_area_in_sp) {
            return false;
        }
        int radius = ServerUtilitiesConfig.world.spawn_radius;
        if (radius <= 0) {
            return false;
        }
        ChunkCoordinates c = server.func_130014_f_().func_72861_E();
        int minX = MathUtils.chunk(c.field_71574_a - radius);
        int minZ = MathUtils.chunk(c.field_71573_c - radius);
        int maxX = MathUtils.chunk(c.field_71574_a + radius);
        int maxZ = MathUtils.chunk(c.field_71573_c + radius);
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    @SubscribeEvent
    public void registerTeamData(ForgeTeamDataEvent event) {
        event.register(new ServerUtilitiesTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public void onCreateServerTeams(UniverseLoadedEvent.CreateServerTeams event) {
        MinecraftForge.EVENT_BUS.register((Object)new ServerUtilitiesTeamData(event.getUniverse().fakePlayerTeam));
    }

    @SubscribeEvent
    public void onUniversePreLoaded(UniverseLoadedEvent.Pre event) {
        if (ServerUtilitiesConfig.world.chunk_claiming) {
            ClaimedChunks.instance = new ClaimedChunks(event.getUniverse());
        }
        Ranks.INSTANCE = new Ranks(event.getUniverse());
    }

    @SubscribeEvent
    public void onUniversePostLoaded(UniverseLoadedEvent.Post event) {
        NBTTagCompound nbt = event.getData("serverutilities");
        WARPS.deserializeNBT(nbt.func_74775_l("Warps"));
    }

    @SubscribeEvent
    public void onUniverseLoaded(UniverseLoadedEvent.Finished event) {
        long now = System.currentTimeMillis();
        Backups.nextBackup = now + Backups.backupMillis();
        shutdownTime = 0L;
        if (ServerUtilitiesConfig.auto_shutdown.enabled && ServerUtilitiesConfig.auto_shutdown.times.length > 0 && (ServerUtilitiesConfig.auto_shutdown.enabled_singleplayer || event.getUniverse().server.func_71262_S())) {
            Calendar calendar = Calendar.getInstance();
            int currentTime = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            IntArrayList times = new IntArrayList(ServerUtilitiesConfig.auto_shutdown.times.length);
            for (String s0 : ServerUtilitiesConfig.auto_shutdown.times) {
                try {
                    String[] s = s0.split(":", 2);
                    int t = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60;
                    if (t <= currentTime) {
                        t += 86400;
                    }
                    times.add(t);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            times.sort((IntComparator)null);
            IntListIterator intListIterator = times.iterator();
            while (intListIterator.hasNext()) {
                int time = (Integer)intListIterator.next();
                if (time <= currentTime) continue;
                shutdownTime = now + (long)(time - currentTime) * 1000L;
                break;
            }
            if (shutdownTime > 0L) {
                Ticks[] ticks;
                ServerUtilities.LOGGER.info("Server will shut down in " + StringUtils.getTimeString(shutdownTime - now));
                for (Ticks t : ticks = new Ticks[]{Ticks.MINUTE.x(30L), Ticks.MINUTE.x(10L), Ticks.MINUTE.x(5L), Ticks.MINUTE.x(1L), Ticks.SECOND.x(10L), Ticks.SECOND.x(9L), Ticks.SECOND.x(8L), Ticks.SECOND.x(7L), Ticks.SECOND.x(6L), Ticks.SECOND.x(5L), Ticks.SECOND.x(4L), Ticks.SECOND.x(3L), Ticks.SECOND.x(2L), Ticks.SECOND.x(1L)}) {
                    event.getUniverse().scheduleTask(TimeType.MILLIS, shutdownTime - t.millis(), universe -> {
                        String timeString = t.toTimeString();
                        for (EntityPlayerMP player : universe.server.func_71203_ab().field_72404_b) {
                            Notification.of(RESTART_TIMER_ID, StringUtils.color(ServerUtilities.lang((ICommandSender)player, "serverutilities.lang.timer.shutdown", timeString), EnumChatFormatting.LIGHT_PURPLE)).send(universe.server, (EntityPlayer)player);
                        }
                    });
                }
            }
        }
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.nextChunkloaderUpdate = now + 1000L;
        }
    }

    public static void worldLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        ServerUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        ServerUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        worldLog.add(out.toString());
        Universe.get().markDirty();
    }

    public static void chatLog(String s) {
        StringBuilder out = new StringBuilder();
        Calendar time = Calendar.getInstance();
        ServerUtilitiesUniverseData.appendNum(out, time.get(1), '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(2) + 1, '-');
        ServerUtilitiesUniverseData.appendNum(out, time.get(5), ' ');
        ServerUtilitiesUniverseData.appendNum(out, time.get(11), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(12), ':');
        ServerUtilitiesUniverseData.appendNum(out, time.get(13), ' ');
        out.append(':');
        out.append(' ');
        out.append(s);
        chatLog.add(out.toString());
        Universe.get().markDirty();
    }

    private static void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    @SubscribeEvent
    public void onUniverseSaved(UniverseSavedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.processQueue();
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Warps", (NBTBase)WARPS.serializeNBT());
        event.setData("serverutilities", nbt);
        if (!worldLog.isEmpty()) {
            ArrayList<String> worldLogCopy = new ArrayList<String>(worldLog);
            worldLog.clear();
            ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile(event.getUniverse().server.func_71209_f("logs/world.log")), true)));){
                    for (String s : worldLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
        if (!chatLog.isEmpty()) {
            ArrayList<String> chatLogCopy = new ArrayList<String>(chatLog);
            chatLog.clear();
            ThreadedFileIOBase.field_75741_a.func_75735_a(() -> {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(FileUtils.newFile(event.getUniverse().server.func_71209_f("logs/chat.log")), true)));){
                    for (String s : chatLogCopy) {
                        out.println(s);
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return false;
            });
        }
    }

    @SubscribeEvent
    public void onUniverseClosed(UniverseClosedEvent event) {
        if (ClaimedChunks.instance != null) {
            ClaimedChunks.instance.clear();
            ClaimedChunks.instance = null;
        }
        Backups.nextBackup = 0L;
        ServerUtilitiesLoadedChunkManager.INSTANCE.clear();
        BADGE_CACHE.clear();
    }

    public static void updateBadge(UUID playerId) {
        BADGE_CACHE.remove(playerId);
    }

    public static String getBadge(Universe universe, UUID playerId) {
        String badge = BADGE_CACHE.get(playerId);
        if (badge != null) {
            return badge;
        }
        badge = ServerUtilitiesUniverseData.getRawBadge(universe, playerId);
        BADGE_CACHE.put(playerId, badge);
        return badge;
    }

    private static String getRawBadge(Universe universe, UUID playerId) {
        ConfigValue value;
        ForgePlayer player;
        block7: {
            player = universe.getPlayer(playerId);
            if (player == null || player.isFake()) {
                return "";
            }
            ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(player);
            if (!data.renderBadge()) {
                return "";
            }
            if (ServerUtilitiesConfig.login.enable_global_badges && !data.disableGlobalBadge()) {
                try {
                    String badge = DataReader.get(new URL(BADGE_URL + StringUtils.fromUUID(playerId)), "text/plain; charset=utf-8", universe.server.func_110454_ao()).string(32);
                    if (!badge.isEmpty()) {
                        return badge;
                    }
                }
                catch (Exception ex) {
                    if (!ServerUtilitiesConfig.debugging.print_more_errors) break block7;
                    ServerUtilities.LOGGER.warn("Badge API errored! " + ex);
                }
            }
        }
        if (Ranks.isActive() && !(value = Ranks.INSTANCE.getPermission(player.getProfile(), "serverutilities.badge", true)).isNull() && !value.isEmpty()) {
            return value.getString();
        }
        return "";
    }

    public static boolean clearBadgeCache() {
        BADGE_CACHE.clear();
        return true;
    }

    static {
        WARPS = new BlockDimPosStorage();
        worldLog = new ArrayList<String>();
        chatLog = new ArrayList<String>();
    }
}

