/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import javax.annotation.Nullable;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.util.permission.DefaultPermissionLevel;

public final class NodeEntry
implements Comparable<NodeEntry> {
    public final String node;
    public final ConfigValue player;
    public final ConfigValue op;
    public final String desc;
    public final DefaultPermissionLevel level;

    public NodeEntry(String n, ConfigValue p, ConfigValue o, String d, @Nullable DefaultPermissionLevel l) {
        this.node = n;
        this.player = p;
        this.op = o;
        this.desc = d;
        this.level = l;
    }

    public NodeEntry(String n, DefaultPermissionLevel l, String d) {
        this(n, new ConfigBoolean(l == DefaultPermissionLevel.ALL), new ConfigBoolean(l != DefaultPermissionLevel.NONE), d, l);
    }

    public String getNode() {
        return this.node;
    }

    public String toString() {
        return this.node;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) return true;
        if (!(o instanceof NodeEntry)) return false;
        NodeEntry entry = (NodeEntry)o;
        if (!this.node.equals(entry.node)) return false;
        return true;
    }

    @Override
    public int compareTo(NodeEntry o) {
        return this.node.compareTo(o.node);
    }
}

