/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Comparator;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import serverutils.data.Leaderboard;
import serverutils.events.LeaderboardRegistryEvent;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.math.Ticks;

public class ServerUtilitiesLeaderboards {
    public static final ServerUtilitiesLeaderboards INST = new ServerUtilitiesLeaderboards();

    @SubscribeEvent
    public void registerLeaderboards(LeaderboardRegistryEvent event) {
        event.register(new Leaderboard.FromStat(new ResourceLocation("serverutilities", "deaths"), StatList.field_75960_y, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard.FromStat(new ResourceLocation("serverutilities", "mob_kills"), StatList.field_75959_z, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard.FromStat(new ResourceLocation("serverutilities", "time_played"), StatList.field_75948_k, false, Leaderboard.FromStat.TIME));
        event.register(new Leaderboard.FromStat(new ResourceLocation("serverutilities", "jumps"), StatList.field_75953_u, false, Leaderboard.FromStat.DEFAULT));
        event.register(new Leaderboard(new ResourceLocation("serverutilities", "deaths_per_hour"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.dph", new Object[0]), player -> {
            double d = ServerUtilitiesLeaderboards.getDPH(player);
            return new ChatComponentText(d < 0.0 ? "-" : String.format("%.2f", d));
        }, Comparator.comparingDouble(ServerUtilitiesLeaderboards::getDPH).reversed(), player -> ServerUtilitiesLeaderboards.getDPH(player) >= 0.0));
        event.register(new Leaderboard(new ResourceLocation("serverutilities", "last_seen"), (IChatComponent)new ChatComponentTranslation("serverutilities.stat.last_seen", new Object[0]), player -> {
            if (player.isOnline()) {
                ChatComponentTranslation component = new ChatComponentTranslation("gui.online", new Object[0]);
                component.func_150256_b().func_150238_a(EnumChatFormatting.GREEN);
                return component;
            }
            long worldTime = player.team.universe.world.func_82737_E();
            int time = (int)(worldTime - player.getLastTimeSeen());
            return Leaderboard.FromStat.TIME.apply(time);
        }, Comparator.comparingLong(ServerUtilitiesLeaderboards::getRelativeLastSeen), player -> player.getLastTimeSeen() != 0L));
    }

    private static long getRelativeLastSeen(ForgePlayer player) {
        if (player.isOnline()) {
            return 0L;
        }
        return player.team.universe.ticks.ticks() - player.getLastTimeSeen();
    }

    private static double getDPH(ForgePlayer player) {
        double hours;
        int playTime = player.stats().func_77444_a(StatList.field_75948_k);
        if (playTime > 0 && (hours = Ticks.get(playTime).hoursd()) >= 1.0) {
            return (double)player.stats().func_77444_a(StatList.field_75960_y) / hours;
        }
        return -1.0;
    }
}

