/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.gui.control;

import com.github.lunatrius.core.client.gui.GuiScreenBase;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.gui.control.GuiSchematicMaterialsSlot;
import com.github.lunatrius.schematica.client.util.BlockList;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.util.ItemStackSortType;
import cpw.mods.fml.client.config.GuiUnicodeGlyphButton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.IOUtils;

public class GuiSchematicMaterials
extends GuiScreenBase {
    private GuiSchematicMaterialsSlot guiSchematicMaterialsSlot;
    private ItemStackSortType sortType = ItemStackSortType.fromString(ConfigurationHandler.sortType);
    private GuiUnicodeGlyphButton btnSort = null;
    private GuiButton btnDump = null;
    private GuiButton btnDone = null;
    private final String strMaterialName = I18n.func_135052_a((String)"schematica.gui.materialname", (Object[])new Object[0]);
    private final String strMaterialAmount = I18n.func_135052_a((String)"schematica.gui.materialamount", (Object[])new Object[0]);
    protected final List<BlockList.WrappedItemStack> blockList;

    public GuiSchematicMaterials(GuiScreen guiScreen) {
        super(guiScreen);
        Minecraft minecraft = Minecraft.func_71410_x();
        SchematicWorld schematic = ClientProxy.schematic;
        this.blockList = new BlockList().getList((EntityPlayer)minecraft.field_71439_g, schematic, minecraft.field_71441_e);
        this.sortType.sort(this.blockList);
    }

    public void func_73866_w_() {
        int id = 0;
        this.btnSort = new GuiUnicodeGlyphButton(++id, this.field_146294_l / 2 - 154, this.field_146295_m - 30, 100, 20, " " + I18n.func_135052_a((String)("schematica.gui.material" + this.sortType.label), (Object[])new Object[0]), this.sortType.glyph, 2.0f);
        this.field_146292_n.add(this.btnSort);
        this.btnDump = new GuiButton(++id, this.field_146294_l / 2 - 50, this.field_146295_m - 30, 100, 20, I18n.func_135052_a((String)"schematica.gui.materialdump", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnDump);
        this.btnDone = new GuiButton(++id, this.field_146294_l / 2 + 54, this.field_146295_m - 30, 100, 20, I18n.func_135052_a((String)"schematica.gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnDone);
        this.guiSchematicMaterialsSlot = new GuiSchematicMaterialsSlot(this);
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l) {
            if (guiButton.field_146127_k == this.btnSort.field_146127_k) {
                this.sortType = this.sortType.next();
                this.sortType.sort(this.blockList);
                this.btnSort.field_146126_j = " " + I18n.func_135052_a((String)("schematica.gui.material" + this.sortType.label), (Object[])new Object[0]);
                this.btnSort.glyph = this.sortType.glyph;
                ConfigurationHandler.propSortType.set(String.valueOf((Object)this.sortType));
                ConfigurationHandler.loadConfiguration();
            } else if (guiButton.field_146127_k == this.btnDump.field_146127_k) {
                this.dumpMaterialList(this.blockList);
            } else if (guiButton.field_146127_k == this.btnDone.field_146127_k) {
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else {
                this.guiSchematicMaterialsSlot.func_148147_a(guiButton);
            }
        }
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.guiSchematicMaterialsSlot.func_148128_a(x, y, partialTicks);
        this.func_73731_b(this.field_146289_q, this.strMaterialName, this.field_146294_l / 2 - 108, 4, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.strMaterialAmount, this.field_146294_l / 2 + 108 - this.field_146289_q.func_78256_a(this.strMaterialAmount), 4, 0xFFFFFF);
        super.func_73863_a(x, y, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMaterialList(List<BlockList.WrappedItemStack> blockList) {
        if (blockList.size() <= 0) {
            return;
        }
        int maxLengthName = 0;
        int maxSize = 0;
        for (BlockList.WrappedItemStack wrappedItemStack : blockList) {
            maxLengthName = Math.max(maxLengthName, wrappedItemStack.getItemStackDisplayName().length());
            maxSize = Math.max(maxSize, wrappedItemStack.total);
        }
        int maxLengthSize = String.valueOf(maxSize).length();
        String formatName = "%-" + maxLengthName + "s";
        String formatSize = "%" + maxLengthSize + "d";
        StringBuilder stringBuilder = new StringBuilder((maxLengthName + 1 + maxLengthSize) * blockList.size());
        Formatter formatter = new Formatter(stringBuilder);
        for (BlockList.WrappedItemStack wrappedItemStack : blockList) {
            formatter.format(formatName, wrappedItemStack.getItemStackDisplayName());
            stringBuilder.append(" ");
            formatter.format(formatSize, wrappedItemStack.total);
            stringBuilder.append(System.lineSeparator());
        }
        File dumps = Schematica.proxy.getDirectory("dumps");
        try (FileOutputStream outputStream = new FileOutputStream(new File(dumps, "Schematica-materials.txt"));){
            IOUtils.write((String)stringBuilder.toString(), (OutputStream)outputStream);
        }
        catch (Exception e) {
            Reference.logger.error("Could not dump the material list!", (Throwable)e);
        }
    }
}

