/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.network.message;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.handler.DownloadHandler;
import com.github.lunatrius.schematica.nbt.NBTHelper;
import com.github.lunatrius.schematica.network.message.MessageDownloadChunkAck;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MessageDownloadChunk
implements IMessage,
IMessageHandler<MessageDownloadChunk, IMessage> {
    public static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    public int baseX;
    public int baseY;
    public int baseZ;
    public short[][][] blocks;
    public byte[][][] metadata;
    public List<TileEntity> tileEntities;
    public List<Entity> entities;

    public MessageDownloadChunk() {
    }

    public MessageDownloadChunk(ISchematic schematic, int baseX, int baseY, int baseZ) {
        this.baseX = baseX;
        this.baseY = baseY;
        this.baseZ = baseZ;
        this.blocks = new short[16][16][16];
        this.metadata = new byte[16][16][16];
        this.tileEntities = new ArrayList<TileEntity>();
        this.entities = new ArrayList<Entity>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    Block block = schematic.getBlock(baseX + x, baseY + y, baseZ + z);
                    int id = BLOCK_REGISTRY.getId((Object)block);
                    this.blocks[x][y][z] = (short)id;
                    this.metadata[x][y][z] = (byte)schematic.getBlockMetadata(baseX + x, baseY + y, baseZ + z);
                    TileEntity tileEntity = schematic.getTileEntity(baseX + x, baseY + y, baseZ + z);
                    if (tileEntity == null) continue;
                    this.tileEntities.add(tileEntity);
                }
            }
        }
    }

    private void copyToSchematic(ISchematic schematic) {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    short id = this.blocks[x][y][z];
                    byte meta = this.metadata[x][y][z];
                    Block block = (Block)BLOCK_REGISTRY.func_148754_a((int)id);
                    schematic.setBlock(this.baseX + x, this.baseY + y, this.baseZ + z, block, meta);
                }
            }
        }
        for (TileEntity tileEntity : this.tileEntities) {
            schematic.setTileEntity(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.baseX = buf.readShort();
        this.baseY = buf.readShort();
        this.baseZ = buf.readShort();
        this.blocks = new short[16][16][16];
        this.metadata = new byte[16][16][16];
        this.tileEntities = new ArrayList<TileEntity>();
        this.entities = new ArrayList<Entity>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    this.blocks[x][y][z] = buf.readShort();
                    this.metadata[x][y][z] = buf.readByte();
                }
            }
        }
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.tileEntities = NBTHelper.readTileEntitiesFromCompound(compound, this.tileEntities);
        NBTTagCompound compound2 = ByteBufUtils.readTag((ByteBuf)buf);
        this.entities = NBTHelper.readEntitiesFromCompound(compound2, this.entities);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.baseX);
        buf.writeShort(this.baseY);
        buf.writeShort(this.baseZ);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    buf.writeShort((int)this.blocks[x][y][z]);
                    buf.writeByte((int)this.metadata[x][y][z]);
                }
            }
        }
        NBTTagCompound compound = NBTHelper.writeTileEntitiesToCompound(this.tileEntities);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
        NBTTagCompound compound1 = NBTHelper.writeEntitiesToCompound(this.entities);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound1);
    }

    public IMessage onMessage(MessageDownloadChunk message, MessageContext ctx) {
        message.copyToSchematic(DownloadHandler.INSTANCE.schematic);
        return new MessageDownloadChunkAck(message.baseX, message.baseY, message.baseZ);
    }
}

