/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.ic2;

import cpw.mods.fml.common.eventhandler.Event;
import gcewing.sg.ITickable;
import gcewing.sg.PowerTE;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class IC2PowerTE
extends PowerTE
implements IEnergySink,
ITickable {
    boolean debugLoad = false;
    boolean debugInput = false;
    static final int maxSafeInput = 2048;
    static final int maxEnergyBuffer = 1000000;
    static final double euPerSGEnergyUnit = 20.0;
    boolean loaded = false;

    public IC2PowerTE() {
        super(1000000.0, 20.0);
    }

    @Override
    public String getScreenTitle() {
        return "IC2 SGPU";
    }

    @Override
    public String getUnitName() {
        return "EU";
    }

    @Override
    public void update() {
        this.load();
    }

    @Override
    public void func_145843_s() {
        this.unload();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unload();
        super.onChunkUnload();
    }

    void load() {
        if (!this.field_145850_b.field_72995_K && !this.loaded) {
            if (this.debugLoad) {
                System.out.printf("SGCraft: IC2PowerTE: Adding to energy network\n", new Object[0]);
            }
            this.loaded = true;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
        }
    }

    void unload() {
        if (!this.field_145850_b.field_72995_K && this.loaded) {
            if (this.debugLoad) {
                System.out.printf("SGCraft: IC2PowerTE: Removing from energy network\n", new Object[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.loaded = false;
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        double eu = Math.min(1000000.0 - this.energyBuffer, 2048.0);
        if (this.debugInput) {
            System.out.printf("SGCraft: IC2PowerTE: Demanding %s EU\n", eu);
        }
        return eu;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.energyBuffer += amount;
        this.markChanged();
        if (this.debugInput) {
            System.out.printf("SGCraft: IC2PowerTE: Injected %s EU giving %s\n", amount, this.energyBuffer);
        }
        return 0.0;
    }

    public int getSinkTier() {
        return 3;
    }
}

