/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BlockPos;
import gcewing.sg.IBlockState;
import gcewing.sg.PowerTE;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PowerBlock<TE extends PowerTE>
extends BaseBlock<TE> {
    PowerTE lastRemovedTE;

    public PowerBlock(Class teClass, BaseBlock.IOrientationHandler orient) {
        super(SGCraft.machineMaterial, orient, teClass);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.lastRemovedTE = (PowerTE)this.getTileEntity((IBlockAccess)world, pos);
        super.breakBlock(world, pos, state);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGCraft.mod.openGui(player, (Enum)SGGui.PowerUnit, world, pos);
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = this.getItemDropped(state, ((World)world).field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1);
        PowerTE te = this.lastRemovedTE;
        if (te != null && te.energyBuffer > 0.0) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.writeContentsToNBT(nbt);
            stack.func_77982_d(nbt);
            this.lastRemovedTE = null;
        }
        ret.add(stack);
        return ret;
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        PowerTE te = (PowerTE)this.getTileEntity((IBlockAccess)world, pos);
        NBTTagCompound nbt = stack.func_77978_p();
        if (te != null && nbt != null) {
            te.readContentsFromNBT(nbt);
        }
    }
}

