/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseRenderTarget;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BaseWorldRenderTarget
extends BaseRenderTarget {
    protected IBlockAccess world;
    protected BlockPos blockPos;
    protected Block block;
    protected Tessellator tess;
    protected float cmr = 1.0f;
    protected float cmg = 1.0f;
    protected float cmb = 1.0f;
    protected boolean ao;
    protected boolean axisAlignedNormal;
    protected boolean renderingOccurred;
    protected float vr;
    protected float vg;
    protected float vb;
    protected float va;
    protected int vlm1;
    protected int vlm2;

    public BaseWorldRenderTarget(IBlockAccess world, BlockPos pos, Tessellator tess, IIcon overrideIcon) {
        super(pos.getX(), pos.getY(), pos.getZ(), overrideIcon);
        this.world = world;
        this.blockPos = pos;
        this.block = world.func_147439_a(pos.x, pos.y, pos.z);
        this.tess = tess;
        this.ao = Minecraft.func_71379_u() && this.block.func_149750_m() == 0;
        this.expandTrianglesToQuads = true;
    }

    @Override
    public void setNormal(Vector3 n) {
        super.setNormal(n);
        this.axisAlignedNormal = n.dot(this.face) >= 0.99;
    }

    @Override
    protected void rawAddVertex(Vector3 p, double u, double v) {
        this.lightVertex(p);
        this.tess.func_78369_a(this.vr, this.vg, this.vb, this.va);
        this.tess.func_78385_a(u, v);
        this.tess.func_78380_c(this.vlm1 << 16 | this.vlm2);
        this.tess.func_78377_a(p.x, p.y, p.z);
        this.renderingOccurred = true;
    }

    protected void lightVertex(Vector3 p) {
        if (this.ao) {
            this.aoLightVertex(p);
        } else {
            this.brLightVertex(p);
        }
    }

    protected void aoLightVertex(Vector3 v) {
        Vector3 n = this.normal;
        double brSum1 = 0.0;
        double brSum2 = 0.0;
        double lvSum = 0.0;
        double wt = 0.0;
        double vx = v.x + 0.5 * n.x;
        double vy = v.y + 0.5 * n.y;
        double vz = v.z + 0.5 * n.z;
        for (int dx = -1; dx <= 1; dx += 2) {
            for (int dy = -1; dy <= 1; dy += 2) {
                for (int dz = -1; dz <= 1; dz += 2) {
                    int br;
                    double woz;
                    double woy;
                    int X = BaseUtils.ifloor(vx + 0.5 * (double)dx);
                    int Y = BaseUtils.ifloor(vy + 0.5 * (double)dy);
                    int Z = BaseUtils.ifloor(vz + 0.5 * (double)dz);
                    BlockPos pos = new BlockPos(X, Y, Z);
                    double wox = dx < 0 ? (double)(X + 1) - (vx - 0.5) : vx + 0.5 - (double)X;
                    double w = wox * (woy = dy < 0 ? (double)(Y + 1) - (vy - 0.5) : vy + 0.5 - (double)Y) * (woz = dz < 0 ? (double)(Z + 1) - (vz - 0.5) : vz + 0.5 - (double)Z);
                    if (!(w > 0.0)) continue;
                    try {
                        br = this.block.func_149677_c(this.world, pos.x, pos.y, pos.z);
                    }
                    catch (RuntimeException e) {
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: getMixedBrightnessForBlock(%s) with weight %s for block at %s: %s\n", pos, w, this.blockPos, e);
                        System.out.printf("BaseWorldRenderTarget.aoLightVertex: v = %s n = %s\n", v, n);
                        throw e;
                    }
                    float lv = !pos.equals(this.blockPos) ? this.world.func_147439_a(pos.x, pos.y, pos.z).func_149685_I() : 1.0f;
                    if (br != 0) {
                        double br1 = (double)(br >> 16 & 0xFF) / 240.0;
                        double br2 = (double)(br & 0xFF) / 240.0;
                        brSum1 += w * br1;
                        brSum2 += w * br2;
                        wt += w;
                    }
                    lvSum += w * (double)lv;
                }
            }
        }
        int brv = wt > 0.0 ? BaseUtils.iround(brSum1 / wt * 240.0) << 16 | BaseUtils.iround(brSum2 / wt * 240.0) : this.block.func_149677_c(this.world, this.blockPos.x, this.blockPos.y, this.blockPos.z);
        float lvv = (float)lvSum;
        this.setLight(this.shade * lvv, brv);
    }

    protected void brLightVertex(Vector3 p) {
        Vector3 n = this.normal;
        BlockPos pos = this.axisAlignedNormal ? new BlockPos((int)Math.floor(p.x + 0.01 * n.x), (int)Math.floor(p.y + 0.01 * n.y), (int)Math.floor(p.z + 0.01 * n.z)) : this.blockPos;
        int br = this.block.func_149677_c(this.world, pos.x, pos.y, pos.z);
        this.setLight(this.shade, br);
    }

    protected void setLight(float shadow, int br) {
        this.vr = shadow * this.cmr * this.r();
        this.vg = shadow * this.cmg * this.g();
        this.vb = shadow * this.cmb * this.b();
        this.va = this.a();
        this.vlm1 = br >> 16;
        this.vlm2 = br & 0xFFFF;
    }

    public boolean end() {
        super.finish();
        return this.renderingOccurred;
    }

    public void setRenderingOccurred() {
        this.renderingOccurred = true;
    }
}

