/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseTileEntity;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.IBlockState;
import gcewing.sg.IProperty;
import gcewing.sg.PropertyTurn;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseOrientation {
    public static boolean debugPlacement = false;
    public static boolean debugOrientation = false;
    public static BaseBlock.IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    public static BaseBlock.IOrientationHandler orient24WaysByTE = new Orient24WaysByTE();

    public static class Orient24WaysByTE
    extends BaseBlock.Orient1Way {
        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
            TileEntity te = world.func_147438_o(pos.x, pos.y, pos.z);
            if (te instanceof BaseTileEntity) {
                BaseTileEntity bte = (BaseTileEntity)te;
                return Trans3.sideTurn(origin, bte.side, bte.turn);
            }
            return super.localToGlobalTransformation(world, pos, state, origin);
        }
    }

    public static class Orient4WaysByState
    implements BaseBlock.IOrientationHandler {
        public static IProperty FACING = new PropertyTurn("facing");

        @Override
        public void defineProperties(BaseBlock block) {
            block.addProperty(FACING);
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState baseState, EntityLivingBase placer) {
            EnumFacing dir = this.getHorizontalFacing((Entity)placer);
            if (debugPlacement) {
                System.out.printf("BaseOrientation.Orient4WaysByState: Placing block with FACING = %s\n", dir);
            }
            return baseState.withProperty(FACING, dir);
        }

        protected EnumFacing getHorizontalFacing(Entity entity) {
            return BaseUtils.horizontalFacings[BaseUtils.iround((double)entity.field_70177_z / 90.0) & 3];
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess world, BlockPos pos, IBlockState state, Vector3 origin) {
            int i;
            EnumFacing f = (EnumFacing)state.getValue(FACING);
            if (debugOrientation) {
                System.out.printf("BaseOrientation.Orient4WaysByState.localToGlobalTransformation: for %s: facing = %s\n", state, f);
            }
            switch (f) {
                case NORTH: {
                    i = 0;
                    break;
                }
                case WEST: {
                    i = 1;
                    break;
                }
                case SOUTH: {
                    i = 2;
                    break;
                }
                case EAST: {
                    i = 3;
                    break;
                }
                default: {
                    i = 0;
                }
            }
            return new Trans3(origin).turn(i);
        }
    }
}

