/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import gcewing.sg.SGInterfaceTE;
import gcewing.sg.cc.CCInterfaceTE;
import gcewing.sg.cc.CCMethod;
import gcewing.sg.cc.CCMethodQueue;
import gcewing.sg.cc.SGMethod;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CCSGPeripheral
implements IPeripheral {
    static CCMethod[] methods = new CCMethod[]{new SGMethod("stargateState"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            SGInterfaceTE.CIStargateState result = te.ciStargateState();
            return new Object[]{result.state, result.chevrons, result.direction};
        }
    }, new SGMethod("energyAvailable"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciEnergyAvailable()};
        }
    }, new SGMethod("energyToDial", 1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciEnergyToDial((String)args[0])};
        }
    }, new SGMethod("localAddress"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciLocalAddress()};
        }
    }, new SGMethod("remoteAddress"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciRemoteAddress()};
        }
    }, new SGMethod("dial", 1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciDial((String)args[0]);
            return null;
        }
    }, new SGMethod("disconnect"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciDisconnect();
            return null;
        }
    }, new SGMethod("irisState"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            return new Object[]{te.ciIrisState()};
        }
    }, new SGMethod("openIris"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciOpenIris();
            return null;
        }
    }, new SGMethod("closeIris"){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciCloseIris();
            return null;
        }
    }, new SGMethod("sendMessage", -1){

        @Override
        Object[] call(SGInterfaceTE te, Object[] args) {
            te.ciSendMessage(args);
            return null;
        }
    }};
    World worldObj;
    int xCoord;
    int yCoord;
    int zCoord;

    public CCSGPeripheral(TileEntity te) {
        this.worldObj = te.func_145831_w();
        this.xCoord = te.field_145851_c;
        this.yCoord = te.field_145848_d;
        this.zCoord = te.field_145849_e;
    }

    CCInterfaceTE getInterfaceTE() {
        TileEntity te = this.worldObj.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        if (te instanceof CCInterfaceTE) {
            return (CCInterfaceTE)te;
        }
        return null;
    }

    public String getType() {
        return "stargate";
    }

    public String[] getMethodNames() {
        String[] result = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = CCSGPeripheral.methods[i].name;
        }
        return result;
    }

    public Object[] callMethod(IComputerAccess cpu, ILuaContext ctx, int method, Object[] args) throws LuaException, InterruptedException {
        if (method >= 0 && method < methods.length) {
            return CCMethodQueue.instance.invoke(cpu, ctx, this, methods[method], args);
        }
        throw new LuaException(String.format("Invalid method index %s", method));
    }

    public void attach(IComputerAccess cpu) {
        System.out.printf("CCSGPeripheral.attach: to %s\n", cpu);
        CCInterfaceTE te = this.getInterfaceTE();
        if (te != null) {
            te.attachedComputers.add(cpu);
        }
    }

    public void detach(IComputerAccess cpu) {
        System.out.printf("CCSGPeripheral.detach: from %s\n", cpu);
        CCInterfaceTE te = this.getInterfaceTE();
        if (te != null) {
            te.attachedComputers.remove(cpu);
        }
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

