/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseTE;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class SGLocation {
    public int dimension;
    public BlockPos pos;

    public SGLocation(TileEntity te) {
        this(BaseUtils.getWorldDimensionId(BaseBlockUtils.getTileEntityWorld(te)), BaseBlockUtils.getTileEntityPos(te));
    }

    public SGLocation(int dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public SGLocation(NBTTagCompound nbt) {
        this.dimension = nbt.func_74762_e("dimension");
        int x = nbt.func_74762_e("x");
        int y = nbt.func_74762_e("y");
        int z = nbt.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
    }

    NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74768_a("x", this.pos.getX());
        nbt.func_74768_a("y", this.pos.getY());
        nbt.func_74768_a("z", this.pos.getZ());
        return nbt;
    }

    SGBaseTE getStargateTE() {
        WorldServer world = SGAddressing.getWorld(this.dimension);
        if (world == null) {
            System.out.printf("SGCraft: SGLocation.getStargateTE: Oh, noes! Dimension %d is not loaded. How can this be?", this.dimension);
            return null;
        }
        TileEntity te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)world, this.pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }
}

