/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseUtils;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGDimensionMap;
import gcewing.sg.SGLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class SGAddressing {
    static boolean debugAddressing = false;
    static AddressingError malformedAddressError = new AddressingError("Malformed stargate address");
    static AddressingError coordRangeError = new AddressingError("Coordinates out of stargate range");
    static AddressingError dimensionRangeError = new AddressingError("Dimension not reachable by stargate");
    public static final String symbolChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final int numSymbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length();
    public static final int numCoordSymbols = 7;
    public static final int numDimensionSymbols = 2;
    public static final int maxAddressLength = 9;
    public static final int maxCoord = 139967;
    public static final int minCoord = -139967;
    public static final int coordRange = 279935;
    public static final int minDirectDimension = -648;
    public static final int maxDimensionIndex = 1295;
    public static final int dimensionRange = 1296;
    static final String padding = "---------";
    static final long mc = 279937L;
    static final long pc = 93563L;
    static final long qc = 153742L;
    static final long md = 1297L;
    static final long pd = 953L;
    static final long qd = 788L;
    static final long mdOld = 1298L;
    static final long qdOld = 459L;

    protected static boolean isValidSymbolChar(char c) {
        return SGAddressing.isValidSymbolChar(String.valueOf(c));
    }

    protected static boolean isValidSymbolChar(String c) {
        return symbolChars.indexOf(c) >= 0;
    }

    protected static char symbolToChar(int i) {
        return symbolChars.charAt(i);
    }

    protected static int charToSymbol(char c) {
        return SGAddressing.charToSymbol(String.valueOf(c));
    }

    protected static int charToSymbol(String c) {
        return symbolChars.indexOf(c);
    }

    protected static boolean validSymbols(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (SGAddressing.charToSymbol(s.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    protected static void validateAddress(String s) throws AddressingError {
        int l = s.length();
        if ((l == 7 || l == 9) && SGAddressing.validSymbols(s)) {
            return;
        }
        throw malformedAddressError;
    }

    public static String normalizeAddress(String address) {
        return address.replace("-", "").toUpperCase();
    }

    protected static String coordSymbolsOf(String address) {
        return address.substring(0, 7);
    }

    protected static String dimensionSymbolsOf(String address) {
        return address.substring(7);
    }

    public static String addressForLocation(SGLocation loc) throws AddressingError {
        if (debugAddressing) {
            System.out.printf("SGAddressing.addressForLocation: coord range = %d to %d\n", -139967, 139967);
        }
        int chunkx = loc.pos.getX() >> 4;
        int chunkz = loc.pos.getZ() >> 4;
        if (!SGAddressing.inCoordRange(chunkx) || !SGAddressing.inCoordRange(chunkz)) {
            throw coordRangeError;
        }
        Integer di = SGDimensionMap.indexForDimension(loc.dimension);
        if (di > 1295) {
            throw dimensionRangeError;
        }
        long c = SGAddressing.interleaveCoords(SGAddressing.hash(chunkx - -139967, 93563L, 279937L), SGAddressing.hash(chunkz - -139967, 93563L, 279937L));
        int dp = SGAddressing.permuteDimension(c, di);
        int d = SGAddressing.hash(dp, 953L, 1297L);
        if (debugAddressing) {
            System.out.printf("SGAddressing.addressForLocation: chunk (%d,%d) in dimension %d gives c = %s d = %d\n", chunkx, chunkz, loc.dimension, c, d);
        }
        return SGAddressing.longToSymbols(c, 7) + SGAddressing.intToSymbols(d, 2);
    }

    public static SGBaseTE findAddressedStargate(String address, World fromWorld) throws AddressingError {
        if (debugAddressing) {
            System.out.printf("SGAddressing.findAddressedStargate: %s\n", address);
        }
        SGAddressing.validateAddress(address);
        String csyms = address.substring(0, 7);
        long c = SGAddressing.longFromSymbols(csyms);
        int[] xz = SGAddressing.uninterleaveCoords(c);
        int chunkX = -139967 + SGAddressing.hash(xz[0], 153742L, 279937L);
        int chunkZ = -139967 + SGAddressing.hash(xz[1], 153742L, 279937L);
        if (debugAddressing) {
            System.out.printf("SGAddressing.findAddressedStargate: c = %s chunk = (%d,%d)\n", c, chunkX, chunkZ);
        }
        SGBaseTE te = null;
        if (address.length() == 9) {
            String dsyms = address.substring(7);
            int d = SGAddressing.intFromSymbols(dsyms);
            int dp = SGAddressing.hash(d, 788L, 1297L);
            int di = SGAddressing.unpermuteDimension(c, dp);
            Integer dm = SGDimensionMap.dimensionForIndex(di);
            if (debugAddressing) {
                System.out.printf("SGAddressing.findAddressedStargate: d = %s dimension = %s\n", d, dm);
            }
            if (dm != null) {
                te = SGAddressing.getBaseTE(chunkX, chunkZ, dm);
            }
            if (te == null) {
                int dimOld = -648 + SGAddressing.hash(d, 459L, 1298L);
                if (debugAddressing) {
                    System.out.printf("SGAddressing.findAddressedStargate: Trying dimension = %s\n", dimOld);
                }
                te = SGAddressing.getBaseTE(chunkX, chunkZ, dimOld);
            }
        } else {
            int dimension = fromWorld.field_73011_w.field_76574_g;
            te = SGAddressing.getBaseTE(chunkX, chunkZ, dimension);
        }
        return te;
    }

    protected static SGBaseTE getBaseTE(int chunkX, int chunkZ, int dimension) {
        Chunk chunk;
        WorldServer toWorld = SGAddressing.getWorld(dimension);
        if (toWorld != null && (chunk = toWorld.func_72964_e(chunkX, chunkZ)) != null) {
            for (Object te : chunk.field_150816_i.values()) {
                if (!(te instanceof SGBaseTE)) continue;
                return (SGBaseTE)te;
            }
        }
        return null;
    }

    protected static int permuteDimension(long c, int d) {
        return (int)(((long)d + c) % 1296L);
    }

    protected static int unpermuteDimension(long c, int d) {
        int i = (int)(((long)d - c) % 1296L);
        if (i < 0) {
            i += 1296;
        }
        return i;
    }

    protected static long interleaveCoords(int x, int z) {
        if (debugAddressing) {
            System.out.printf("SGAddressing.interleaveCoords: %d, %d\n", x, z);
        }
        long p6 = 1L;
        long c = 0L;
        while (x > 0 || z > 0) {
            if (debugAddressing) {
                System.out.printf("SGAddressing.interleaveCoords: half-digits %d %d\n", x % 6, z % 6);
            }
            c += p6 * (long)(x % 6);
            x /= 6;
            c += (p6 *= 6L) * (long)(z % 6);
            z /= 6;
            p6 *= 6L;
        }
        return c;
    }

    protected static int[] uninterleaveCoords(long c) {
        int p6 = 1;
        int[] xy = new int[]{0, 0};
        while (c > 0L) {
            xy[0] = (int)((long)xy[0] + (long)p6 * (c % 6L));
            xy[1] = (int)((long)xy[1] + (long)p6 * ((c /= 6L) % 6L));
            c /= 6L;
            p6 *= 6;
        }
        return xy;
    }

    protected static int hash(int i, long f, long m) {
        int h = (int)((long)(i + 1) * f % m) - 1;
        if (debugAddressing) {
            System.out.printf("SGAddressing.hash(%s, %s, %s) = %s\n", i, f, m, h);
        }
        return h;
    }

    public static WorldServer getWorld(int dimension) {
        return BaseUtils.getWorldForDimension(dimension);
    }

    protected static boolean inCoordRange(int i) {
        return i >= -139967 && i <= 139967;
    }

    protected static String intToSymbols(int i, int n) {
        return SGAddressing.longToSymbols(i, n);
    }

    protected static String longToSymbols(long i, int n) {
        String s = "";
        while (n-- > 0) {
            s = SGAddressing.symbolToChar((int)(i % (long)numSymbols)) + s;
            i /= (long)numSymbols;
        }
        return s;
    }

    protected static int intFromSymbols(String s) {
        return (int)SGAddressing.longFromSymbols(s);
    }

    protected static long longFromSymbols(String s) {
        long i = 0L;
        int n = s.length();
        for (int j = 0; j < n; ++j) {
            char c = s.charAt(j);
            i = i * (long)numSymbols + (long)SGAddressing.charToSymbol(c);
        }
        return i;
    }

    public static String padAddress(String address, String caret, int maxLength) {
        if (maxLength < 7) {
            maxLength = 7;
        }
        return SGAddressing.formatAddress(address + padding.substring(address.length(), maxLength), " ", " ");
    }

    public static String formatAddress(String address, String sep1, String sep2) {
        String coord = address.substring(0, 7);
        String dimen = address.substring(7);
        int i = 4;
        String result = coord.substring(0, i) + sep1 + coord.substring(i);
        if (dimen.length() > 0) {
            result = result + sep2 + dimen;
        }
        return result;
    }

    public static String localAddress(String address) {
        return address.substring(0, 7);
    }

    static class AddressingError
    extends Exception {
        AddressingError(String s) {
            super(s);
        }
    }
}

