/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import java.lang.reflect.Constructor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class BaseContainer
extends Container {
    int xSize;
    int ySize;
    SlotRange playerSlotRange;
    SlotRange containerSlotRange;

    public BaseContainer(int width, int height) {
        this.xSize = width;
        this.ySize = height;
    }

    public BaseContainer(int width, int height, EntityPlayer player) {
        this(width, height);
        this.addPlayerSlots(player);
    }

    protected void beginContainerSlots() {
        this.containerSlotRange = new SlotRange();
    }

    protected void endContainerSlots() {
        this.containerSlotRange.end();
    }

    protected void beginPlayerSlots() {
        this.playerSlotRange = new SlotRange();
    }

    protected void endPlayerSlots() {
        this.playerSlotRange.end();
    }

    public void addPlayerSlots(EntityPlayer player) {
        this.addPlayerSlots(player, (this.xSize - 160) / 2, this.ySize - 82);
    }

    public void addPlayerSlots(EntityPlayer player, int x, int y) {
        int var3;
        this.beginPlayerSlots();
        InventoryPlayer inventory = player.field_71071_by;
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.func_75146_a(new Slot((IInventory)inventory, var4 + var3 * 9 + 9, x + var4 * 18, y + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.func_75146_a(new Slot((IInventory)inventory, var3, x + var3 * 18, y + 58));
        }
        this.endPlayerSlots();
    }

    public void addPlayerSlotsRotated(EntityPlayer player, int x, int y) {
        int var3;
        this.beginPlayerSlots();
        InventoryPlayer inventory = player.field_71071_by;
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.func_75146_a(new Slot((IInventory)inventory, var4 + var3 * 9 + 9, x + 58 - var3 * 18, y + var4 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.func_75146_a(new Slot((IInventory)inventory, var3, x, y + var3 * 18));
        }
        this.endPlayerSlots();
    }

    public SlotRange addSlots(IInventory inventory, int x, int y, int numRows) {
        return this.addSlots(inventory, 0, inventory.func_70302_i_(), x, y, numRows);
    }

    public SlotRange addSlots(IInventory inventory, int x, int y, int numRows, Class slotClass) {
        return this.addSlots(inventory, 0, inventory.func_70302_i_(), x, y, numRows, slotClass);
    }

    public SlotRange addSlots(IInventory inventory, int firstSlot, int numSlots, int x, int y, int numRows) {
        return this.addSlots(inventory, firstSlot, numSlots, x, y, numRows, Slot.class);
    }

    public SlotRange addSlots(IInventory inventory, int firstSlot, int numSlots, int x, int y, int numRows, Class slotClass) {
        SlotRange range = new SlotRange();
        try {
            Constructor slotCon = slotClass.getConstructor(IInventory.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            int numCols = (numSlots + numRows - 1) / numRows;
            for (int i = 0; i < numSlots; ++i) {
                int row = i / numCols;
                int col = i % numCols;
                this.func_75146_a((Slot)slotCon.newInstance(inventory, firstSlot + i, x + col * 18, y + row * 18));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        range.end();
        return range;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting crafter = (ICrafting)this.field_75149_d.get(i);
            this.sendStateTo(crafter);
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        SlotRange destRange;
        ItemStack result = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        ItemStack stack = slot.func_75211_c();
        if (slot != null && slot.func_75216_d() && (destRange = this.transferSlotRange(index, stack)) != null) {
            result = stack.func_77946_l();
            if (!this.mergeItemStackIntoRange(stack, destRange)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return result;
    }

    protected boolean mergeItemStackIntoRange(ItemStack stack, SlotRange range) {
        return this.func_75135_a(stack, range.firstSlot, range.firstSlot + range.numSlots, range.reverseMerge);
    }

    protected boolean func_75135_a(ItemStack stack, int startSlot, int endSlot, boolean reverse) {
        Slot slot;
        int k;
        int i;
        boolean result = false;
        int n = endSlot - startSlot;
        if (stack.func_77985_e()) {
            for (i = 0; i < n && stack.field_77994_a > 0; ++i) {
                k = reverse ? endSlot - 1 - i : startSlot + i;
                slot = (Slot)this.field_75151_b.get(k);
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack == null || !slotStack.func_77985_e() || slotStack.func_77973_b() != stack.func_77973_b() || stack.func_77981_g() && stack.func_77960_j() != slotStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack) || !this.transferToSlot(stack, slot)) continue;
                result = true;
            }
        }
        for (i = 0; i < n && stack.field_77994_a > 0; ++i) {
            k = reverse ? endSlot - 1 - i : startSlot + i;
            slot = (Slot)this.field_75151_b.get(k);
            if (slot.func_75216_d() || !slot.func_75214_a(stack)) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = 0;
            slot.func_75215_d(newStack);
            if (!this.transferToSlot(stack, slot)) continue;
            result = true;
        }
        return result;
    }

    protected boolean transferToSlot(ItemStack stack, Slot slot) {
        ItemStack slotStack = slot.func_75211_c();
        int oldSlotSize = slotStack.field_77994_a;
        int slotLimit = Math.min(stack.func_77976_d(), slot.func_75219_a());
        int newSlotSize = Math.min(oldSlotSize + stack.field_77994_a, slotLimit);
        int transferSize = newSlotSize - oldSlotSize;
        if (transferSize > 0) {
            stack.field_77994_a -= transferSize;
            slotStack.field_77994_a += transferSize;
            slot.func_75218_e();
            return true;
        }
        return false;
    }

    protected SlotRange transferSlotRange(int srcSlotIndex, ItemStack stack) {
        if (this.playerSlotRange.contains(srcSlotIndex)) {
            return this.containerSlotRange;
        }
        if (this.containerSlotRange.contains(srcSlotIndex)) {
            return this.playerSlotRange;
        }
        return null;
    }

    void sendStateTo(ICrafting crafter) {
    }

    public void func_75137_b(int i, int value) {
    }

    public class SlotRange {
        public int firstSlot;
        public int numSlots;
        public boolean reverseMerge;

        public SlotRange() {
            this.firstSlot = BaseContainer.this.field_75151_b.size();
        }

        public void end() {
            this.numSlots = BaseContainer.this.field_75151_b.size() - this.firstSlot;
        }

        public boolean contains(int slot) {
            return slot >= this.firstSlot && slot < this.firstSlot + this.numSlots;
        }

        public String toString() {
            return String.format("SlotRange(%s to %s)", this.firstSlot, this.firstSlot + this.numSlots - 1);
        }
    }
}

