/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseTileEntity;
import gcewing.sg.SGAddressing;
import gcewing.sg.SGBaseTE;
import net.minecraft.world.IBlockAccess;

public class SGInterfaceTE
extends BaseTileEntity {
    public SGBaseTE getBaseTE() {
        return SGBaseTE.get((IBlockAccess)this.field_145850_b, this.getPos().add(0, 1, 0));
    }

    public static Object[] prependArgs(Object ... args) {
        int i;
        int preLength = args.length - 1;
        Object[] post = (Object[])args[preLength];
        Object[] xargs = new Object[preLength + post.length];
        for (i = 0; i < preLength; ++i) {
            xargs[i] = args[i];
        }
        for (i = 0; i < post.length; ++i) {
            xargs[preLength + i] = post[i];
        }
        return xargs;
    }

    public void rebroadcastNetworkPacket(Object packet) {
    }

    public SGBaseTE requireBaseTE() {
        SGBaseTE te = this.getBaseTE();
        if (te != null && te.isMerged) {
            return te;
        }
        throw new IllegalArgumentException("No stargate connected to interface");
    }

    public SGBaseTE requireIrisTE() {
        SGBaseTE te = this.requireBaseTE();
        if (te != null && te.hasIrisUpgrade) {
            return te;
        }
        throw new IllegalArgumentException("No iris fitted to stargate");
    }

    String directionDescription(SGBaseTE te) {
        if (te.isConnected()) {
            if (te.isInitiator) {
                return "Outgoing";
            }
            return "Incoming";
        }
        return "";
    }

    public CIStargateState ciStargateState() {
        SGBaseTE te = this.getBaseTE();
        if (te != null) {
            return new CIStargateState(te.sgStateDescription(), te.numEngagedChevrons, this.directionDescription(te));
        }
        return new CIStargateState("Offline", 0, "");
    }

    public double ciEnergyAvailable() {
        SGBaseTE te = this.getBaseTE();
        if (te != null) {
            return te.availableEnergy();
        }
        return 0.0;
    }

    public double ciEnergyToDial(String address) {
        SGBaseTE te = this.requireBaseTE();
        try {
            address = SGAddressing.normalizeAddress(address);
            SGBaseTE dte = SGAddressing.findAddressedStargate(address, BaseBlockUtils.getTileEntityWorld(te));
            if (dte == null) {
                throw new IllegalArgumentException("No stargate at address " + address);
            }
            double distanceFactor = SGBaseTE.distanceFactorForCoordDifference(te, dte);
            return SGBaseTE.energyToOpen * distanceFactor;
        }
        catch (SGAddressing.AddressingError e) {
            System.out.printf("SGBaseTE.ciEnergyToDial: caught %s\n", e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String ciLocalAddress() {
        SGBaseTE te = this.getBaseTE();
        try {
            if (te != null) {
                return te.getHomeAddress();
            }
            return "";
        }
        catch (SGAddressing.AddressingError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String ciRemoteAddress() {
        SGBaseTE te = this.requireBaseTE();
        try {
            if (te.connectedLocation != null) {
                return SGAddressing.addressForLocation(te.connectedLocation);
            }
            return "";
        }
        catch (SGAddressing.AddressingError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void ciDial(String address) {
        SGBaseTE te = this.requireBaseTE();
        String error = te.connect(address = SGAddressing.normalizeAddress(address), null);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public void ciDisconnect() {
        SGBaseTE te = this.requireBaseTE();
        String error = te.attemptToDisconnect(null);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public String ciIrisState() {
        SGBaseTE te = this.getBaseTE();
        if (te != null && te.hasIrisUpgrade) {
            return te.irisStateDescription();
        }
        return "Offline";
    }

    public void ciOpenIris() {
        this.requireIrisTE().openIris();
    }

    public void ciCloseIris() {
        this.requireIrisTE().closeIris();
    }

    public void ciSendMessage(Object[] args) {
        SGBaseTE te = this.requireBaseTE();
        String error = te.sendMessage(args);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public static class CIStargateState {
        public String state;
        public int chevrons;
        public String direction;

        public CIStargateState(String state, int chevrons, String direction) {
            this.state = state;
            this.chevrons = chevrons;
            this.direction = direction;
        }
    }
}

