/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseDataChannel;
import gcewing.sg.BaseUtils;
import gcewing.sg.BlockPos;
import gcewing.sg.DHDTE;
import gcewing.sg.SGBaseTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class SGChannel
extends BaseDataChannel {
    protected static BaseDataChannel channel;

    public SGChannel(String name) {
        super(name, new Object[0]);
        channel = this;
    }

    public static void sendConnectOrDisconnectToServer(SGBaseTE te, String address) {
        BaseDataChannel.ChannelOutput data = channel.openServer("ConnectOrDisconnect");
        SGChannel.writeCoords(data, te);
        data.writeUTF(address);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="ConnectOrDisconnect")
    public void handleConnectOrDisconnectFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        String address = data.readUTF();
        SGBaseTE te = SGBaseTE.at((IBlockAccess)player.field_70170_p, pos);
        System.out.printf("SGChannel.handleConnectOrDisconnectFromClient: %s %s %s\n", pos, address, te);
        if (te != null) {
            te.connectOrDisconnect(address, player);
        }
    }

    public static void sendEnteredAddressToServer(DHDTE te, String address) {
        BaseDataChannel.ChannelOutput data = channel.openServer("EnteredAddress");
        SGChannel.writeCoords(data, te);
        data.writeUTF(address);
        data.close();
    }

    @BaseDataChannel.ServerMessageHandler(value="EnteredAddress")
    public void handleEnteredAddressFromClient(EntityPlayer player, BaseDataChannel.ChannelInput data) {
        BlockPos pos = this.readCoords(data);
        String address = data.readUTF();
        DHDTE te = DHDTE.at((IBlockAccess)player.field_70170_p, pos);
        if (te != null) {
            te.setEnteredAddress(address);
        }
    }

    public static void writeCoords(BaseDataChannel.ChannelOutput data, TileEntity te) {
        BaseUtils.writeBlockPos(data, BaseBlockUtils.getTileEntityPos(te));
    }

    public BlockPos readCoords(BaseDataChannel.ChannelInput data) {
        return BaseUtils.readBlockPos(data);
    }
}

