/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import gcewing.sg.BaseBlock;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseModClient;
import gcewing.sg.BaseModel;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.BlockPos;
import gcewing.sg.IBlockState;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod<CLIENT extends BaseModClient<? extends BaseMod>>
extends BaseSubsystem
implements IGuiHandler {
    protected Map<ResourceLocation, BaseModClient.IModel> modelCache = new HashMap<ResourceLocation, BaseModClient.IModel>();
    public String modID;
    public BaseConfiguration config;
    public String modPackage;
    public String assetKey;
    public String blockDomain;
    public String itemDomain;
    public String resourceDir;
    public URL resourceURL;
    public CLIENT client;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    public CreativeTabs creativeTab;
    public File cfgFile;
    public List<Block> registeredBlocks = new ArrayList<Block>();
    public List<Item> registeredItems = new ArrayList<Item>();
    public List<BaseSubsystem> subsystems = new ArrayList<BaseSubsystem>();
    public boolean debugGui = false;
    public boolean debugBlockRegistration = false;
    public boolean debugCreativeTabs = false;
    public List<VSBinding> registeredVillagers = new ArrayList<VSBinding>();
    protected int nextGuiId = 1000;
    Map<Class<? extends Container>, Class<? extends TileEntity>> containerTEClasses = new HashMap<Class<? extends Container>, Class<? extends TileEntity>>();
    Map<Object, Integer> objectToGuiId = new HashMap<Object, Integer>();
    Map<Integer, Class<? extends Container>> containerClasses = new HashMap<Integer, Class<? extends Container>>();

    public void setModOf(Object obj) {
        if (obj instanceof ISetMod) {
            ((ISetMod)obj).setMod(this);
        }
    }

    public String resourcePath(String fileName) {
        return this.resourceDir + fileName;
    }

    public BaseMod() {
        Class<?> modClass = this.getClass();
        this.modPackage = modClass.getPackage().getName();
        this.modID = BaseMod.getModID(modClass);
        this.blockDomain = this.assetKey = this.modID.toLowerCase();
        this.itemDomain = this.assetKey;
        String resourceRelDir = "assets/" + this.assetKey + "/";
        this.resourceDir = "/" + resourceRelDir;
        this.resourceURL = this.getClass().getClassLoader().getResource(resourceRelDir);
        this.subsystems.add(this);
        this.creativeTab = CreativeTabs.field_78026_f;
    }

    static String getModID(Class cls) {
        Mod ann = cls.getAnnotation(Mod.class);
        if (ann instanceof Mod) {
            return ann.modid();
        }
        System.out.printf("BaseMod: Mod annotation not found\n", new Object[0]);
        return "<unknown>";
    }

    public static boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        this.serverSide = e.getSide().isServer();
        this.clientSide = e.getSide().isClient();
        if (this.clientSide) {
            this.client = this.initClient();
            this.proxy = this.client;
        }
        this.cfgFile = e.getSuggestedConfigurationFile();
        this.loadConfig();
        this.configure();
        for (BaseSubsystem sub : this.subsystems) {
            if (sub != this) {
                sub.preInit(e);
            }
            sub.configure(this.config);
            sub.registerBlocks();
            sub.registerTileEntities();
            sub.registerItems();
            sub.registerOres();
            sub.registerWorldGenerators();
            sub.registerContainers();
            sub.registerEntities();
            sub.registerVillagers();
        }
        if (this.client != null) {
            ((BaseModClient)this.client).preInit(e);
        }
    }

    @Override
    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (this.client != null) {
            ((BaseModClient)this.client).init(e);
        }
        for (BaseSubsystem sub : this.subsystems) {
            if (sub == this) continue;
            sub.init(e);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        for (BaseSubsystem sub : this.subsystems) {
            if (sub != this) {
                sub.postInit(e);
            }
            sub.registerRecipes();
            sub.registerRandomItems();
            sub.registerOther();
        }
        if (this.client != null) {
            ((BaseModClient)this.client).postInit(e);
        }
        if (this.proxy == null) {
            this.proxy = this;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, this.proxy);
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String name) {
        return this.modPackage + "." + name;
    }

    @Override
    protected void registerScreens() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerScreens();
        }
    }

    @Override
    protected void registerBlockRenderers() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerBlockRenderers();
        }
    }

    @Override
    protected void registerItemRenderers() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerItemRenderers();
        }
    }

    @Override
    protected void registerEntityRenderers() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerEntityRenderers();
        }
    }

    @Override
    protected void registerTileEntityRenderers() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerTileEntityRenderers();
        }
    }

    @Override
    protected void registerOtherClient() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerOther();
        }
    }

    void configure() {
    }

    CLIENT initClient() {
        return (CLIENT)new BaseModClient<BaseMod>(this);
    }

    public BaseSubsystem integrateWithMod(String modId, String subsystemClassName) {
        if (BaseMod.isModLoaded(modId)) {
            return this.loadSubsystem(subsystemClassName);
        }
        return null;
    }

    public BaseSubsystem integrateWithClass(String className, String subsystemClassName) {
        if (BaseMod.classAvailable(className)) {
            return this.loadSubsystem(subsystemClassName);
        }
        return null;
    }

    public BaseSubsystem loadSubsystem(String className) {
        BaseSubsystem sub = this.newSubsystem(className);
        sub.mod = this;
        sub.client = this.client;
        this.subsystems.add(sub);
        return sub;
    }

    protected BaseSubsystem newSubsystem(String className) {
        try {
            return (BaseSubsystem)Class.forName(className).newInstance();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static boolean classAvailable(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Item newItem(String name) {
        return this.newItem(name, Item.class);
    }

    public <ITEM extends Item> ITEM newItem(String name, Class<ITEM> cls) {
        Item item;
        try {
            Constructor<ITEM> ctor = cls.getConstructor(new Class[0]);
            item = (Item)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (ITEM)this.addItem(item, name);
    }

    public <ITEM extends Item> ITEM addItem(ITEM item, String name) {
        String qualName = this.itemDomain + ":" + name;
        item.func_77655_b(qualName);
        item.func_111206_d(this.assetKey + ":" + name);
        GameRegistry.registerItem(item, (String)name);
        if (this.debugBlockRegistration) {
            System.out.printf("BaseMod.addItem: Registered %s as %s\n", item, name);
        }
        if (this.creativeTab != null) {
            if (this.debugCreativeTabs) {
                System.out.printf("BaseMod.addItem: Setting creativeTab of %s to %s\n", name, this.creativeTab);
            }
            item.func_77637_a(this.creativeTab);
        }
        this.registeredItems.add(item);
        return item;
    }

    public Block newBlock(String name) {
        return this.newBlock(name, Block.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls) {
        return this.newBlock(name, cls, null);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls, Class itemClass) {
        Block block;
        try {
            Constructor<BLOCK> ctor = cls.getConstructor(new Class[0]);
            block = (Block)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (BLOCK)this.addBlock(block, name, itemClass);
    }

    public <BLOCK extends Block> BLOCK addBlock(String name, BLOCK block) {
        return this.addBlock(block, name);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK block, String name) {
        return this.addBlock(block, name, null);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK block, String name, Class itemClass) {
        String qualName = this.blockDomain + ":" + name;
        block.func_149663_c(qualName);
        block.func_149658_d(this.assetKey + ":" + name);
        itemClass = this.getItemClassForBlock(block, itemClass);
        GameRegistry.registerBlock(block, (Class)itemClass, (String)name);
        if (this.creativeTab != null) {
            block.func_149647_a(this.creativeTab);
        }
        if (block instanceof BaseBlock) {
            ((BaseBlock)block).mod = this;
        }
        this.registeredBlocks.add(block);
        return block;
    }

    protected Class defaultItemClassForBlock(Block block) {
        if (block instanceof IBlock) {
            return ((IBlock)block).getDefaultItemClass();
        }
        return ItemBlock.class;
    }

    protected Class getItemClassForBlock(Block block, Class suppliedClass) {
        Class baseClass = this.defaultItemClassForBlock(block);
        if (suppliedClass == null) {
            return baseClass;
        }
        if (!baseClass.isAssignableFrom(suppliedClass)) {
            throw new RuntimeException(String.format("Block item class %s for %s does not extend %s\n", suppliedClass.getName(), block.func_149739_a(), baseClass.getName()));
        }
        return suppliedClass;
    }

    public void addOre(String name, Block block) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(block));
    }

    public void addOre(String name, Item item) {
        OreDictionary.registerOre((String)name, (Item)item);
    }

    public void addOre(String name, ItemStack stack) {
        OreDictionary.registerOre((String)name, (ItemStack)stack);
    }

    public static boolean blockMatchesOre(Block block, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(block), name);
    }

    public static boolean itemMatchesOre(Item item, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(item), name);
    }

    public static boolean stackMatchesOre(ItemStack stack, String name) {
        int id2 = OreDictionary.getOreID((String)name);
        for (int id1 : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (id1 != id2) continue;
            return true;
        }
        return false;
    }

    public void newRecipe(Item product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(Block product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(product, params));
    }

    public void newShapelessRecipe(Block product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(Item product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(product, params));
    }

    public void newSmeltingRecipe(Item product, int qty, Item input) {
        this.newSmeltingRecipe(product, qty, input, 0);
    }

    public void newSmeltingRecipe(Item product, int qty, Item input, int xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)new ItemStack(product, qty), (float)xp);
    }

    public void newSmeltingRecipe(Item product, int qty, Block input) {
        this.newSmeltingRecipe(product, qty, input, 0);
    }

    public void newSmeltingRecipe(Item product, int qty, Block input, int xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)new ItemStack(product, qty), (float)xp);
    }

    public void addEntity(Class<? extends Entity> cls, String name, Enum id) {
        this.addEntity(cls, name, id.ordinal());
    }

    public void addEntity(Class<? extends Entity> cls, String name, int id) {
        this.addEntity(cls, name, id, 1, true);
    }

    public void addEntity(Class<? extends Entity> cls, String name, Enum id, int updateFrequency, boolean sendVelocityUpdates) {
        this.addEntity(cls, name, id.ordinal(), updateFrequency, sendVelocityUpdates);
    }

    public void addEntity(Class<? extends Entity> cls, String name, int id, int updateFrequency, boolean sendVelocityUpdates) {
        System.out.printf("%s: BaseMod.addEntity: %s, \"%s\", %s\n", this.getClass().getSimpleName(), cls.getSimpleName(), name, id);
        EntityRegistry.registerModEntity(cls, (String)name, (int)id, (Object)this, (int)256, (int)updateFrequency, (boolean)sendVelocityUpdates);
    }

    int addVillager(String name, ResourceLocation skin) {
        int id = this.config.getVillager(name);
        VSBinding b = new VSBinding();
        b.id = id;
        b.object = skin;
        this.registeredVillagers.add(b);
        return id;
    }

    void addTradeHandler(int villagerID, VillagerRegistry.IVillageTradeHandler handler) {
        VillagerRegistry.instance().registerVillageTradeHandler(villagerID, handler);
    }

    public void registerStructureComponent(Class cls, String name) {
        MapGenStructureIO.func_143031_a((Class)cls, (String)name);
    }

    public ResourceLocation resourceLocation(String path) {
        if (path.contains(":")) {
            return new ResourceLocation(path);
        }
        return new ResourceLocation(this.assetKey, path);
    }

    public String soundName(String name) {
        return this.assetKey + ":" + name;
    }

    public ResourceLocation textureLocation(String path) {
        return this.resourceLocation("textures/" + path);
    }

    public ResourceLocation modelLocation(String path) {
        return this.resourceLocation("models/" + path);
    }

    public BaseModClient.IModel getModel(String name) {
        ResourceLocation loc = this.modelLocation(name);
        BaseModClient.IModel model = this.modelCache.get(loc);
        if (model == null) {
            model = BaseModel.fromResource(loc);
            this.modelCache.put(loc, model);
        }
        return model;
    }

    public static void sendTileEntityUpdate(TileEntity te) {
        Packet packet = te.func_145844_m();
        if (packet != null) {
            int x = te.field_145851_c >> 4;
            int z = te.field_145849_e >> 4;
            WorldServer world = (WorldServer)te.func_145831_w();
            ServerConfigurationManager cm = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab();
            PlayerManager pm = world.func_73040_p();
            for (EntityPlayerMP player : cm.field_72404_b) {
                if (!pm.func_72694_a(player, x, z)) continue;
                player.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Override
    protected void registerContainers() {
    }

    public int getGuiId(Object obj) {
        Integer id = this.objectToGuiId.get(obj);
        if (id != null) {
            return id;
        }
        return -1;
    }

    public void addContainer(Enum id, Class<? extends Container> cls) {
        this.addContainer(id.ordinal(), cls);
    }

    public int addContainer(Class<? extends Container> cls) {
        return this.addContainer(cls, null);
    }

    public int addContainer(Class<? extends Container> cls, Class<? extends TileEntity> teCls) {
        int id = this.nextGuiId++;
        this.addContainer(id, cls, teCls);
        return id;
    }

    public void addContainer(int id, Class<? extends Container> cls) {
        this.addContainer(id, cls, null);
    }

    public void addContainer(int id, Class<? extends Container> cls, Class<? extends TileEntity> teCls) {
        if (this.containerClasses.containsKey(id)) {
            throw new RuntimeException("Duplicate container registration with ID " + id);
        }
        this.containerClasses.put(id, cls);
        this.objectToGuiId.put(cls, id);
        if (teCls != null) {
            this.containerTEClasses.put(cls, teCls);
            this.objectToGuiId.put(teCls, id);
        }
    }

    public void openGui(EntityPlayer player, Enum id, TileEntity te) {
        this.openGui(player, id, te, 0);
    }

    public void openGui(EntityPlayer player, Enum id, TileEntity te, int param) {
        this.openGui(player, id.ordinal(), te, param);
    }

    public void openGui(EntityPlayer player, TileEntity te) {
        this.openGui(player, -1, te, 0);
    }

    public void openGui(EntityPlayer player, int id, TileEntity te) {
        this.openGui(player, id, te, 0);
    }

    public void openGui(EntityPlayer player, TileEntity te, int param) {
        this.openGui(player, -1, te, param);
    }

    public void openGui(EntityPlayer player, int id, TileEntity te, int param) {
        if (id < 0) {
            id = this.getGuiId(te);
        }
        this.openGui(player, id, te.func_145831_w(), new BlockPos(te), param);
    }

    public void openGui(EntityPlayer player, Enum id, World world, BlockPos pos) {
        this.openGui(player, id, world, pos, 0);
    }

    public void openGui(EntityPlayer player, Enum id, World world, BlockPos pos, int param) {
        this.openGui(player, id.ordinal(), world, pos, param);
    }

    public void openGui(EntityPlayer player, int id, World world, BlockPos pos, int param) {
        this.openGui(player, id | param << 16, world, pos);
    }

    public void openGui(EntityPlayer player, int id, World world, BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        if (this.debugGui) {
            System.out.printf("BaseMod.openGui: for %s with id 0x%x in %s at (%s, %s, %s)\n", this, id, world, x, y, z);
        }
        player.openGui((Object)this, id, world, x, y, z);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return this.getServerGuiElement(id, player, world, new BlockPos(x, y, z));
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, BlockPos pos) {
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: for id 0x%x\n", id);
        }
        int param = id >> 16;
        Class<? extends Container> cls = this.containerClasses.get(id &= 0xFFFF);
        Object result = cls != null ? this.createGuiElement(cls, player, world, pos, param) : this.getGuiContainer(id, player, world, pos, param);
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: Returning %s\n", result);
        }
        this.setModOf(result);
        return result;
    }

    Container getGuiContainer(int id, EntityPlayer player, World world, BlockPos pos, int param) {
        if (this.debugGui) {
            System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, id);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    Object createGuiElement(Class cls, EntityPlayer player, World world, BlockPos pos, int param) {
        try {
            TileEntity te;
            Constructor c;
            Method m;
            if (this.debugGui) {
                System.out.printf("BaseMod.createGuiElement: Looking for create method on %s for %s in %s\n", cls, player, world);
            }
            if ((m = this.getMethod(cls, "create", EntityPlayer.class, World.class, BlockPos.class, Integer.TYPE)) != null) {
                return m.invoke(null, player, world, pos, param);
            }
            m = this.getMethod(cls, "create", EntityPlayer.class, World.class, BlockPos.class);
            if (m != null) {
                return m.invoke(null, player, world, pos);
            }
            if (this.debugGui) {
                System.out.printf("BaseMod.createGuiElement: Looking for constructor on %s\n", cls);
            }
            if ((c = this.getConstructor(cls, EntityPlayer.class, World.class, BlockPos.class, Integer.TYPE)) != null) {
                return c.newInstance(player, world, pos, param);
            }
            c = this.getConstructor(cls, EntityPlayer.class, World.class, BlockPos.class);
            if (c != null) {
                return c.newInstance(player, world, pos);
            }
            Class<? extends TileEntity> teCls = this.containerTEClasses.get(cls);
            if (teCls != null && (te = BaseBlockUtils.getWorldTileEntity((IBlockAccess)world, pos)) != null) {
                c = this.getConstructor(cls, EntityPlayer.class, teCls, Integer.TYPE);
                if (c != null) {
                    return c.newInstance(player, te, param);
                }
                c = this.getConstructor(cls, EntityPlayer.class, teCls);
                if (c != null) {
                    return c.newInstance(player, te);
                }
            }
            throw new RuntimeException(String.format("%s: No suitable gui element constructor found for %s\n", this.modID, cls));
        }
        catch (Exception e) {
            BaseMod.reportExceptionCause(e);
            return null;
        }
    }

    Method getMethod(Class cls, String name, Class ... argTypes) {
        try {
            return cls.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    Constructor getConstructor(Class cls, Class ... argTypes) {
        try {
            return cls.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void reportExceptionCause(Exception e) {
        Throwable cause = e.getCause();
        System.out.printf("BaseMod.createGuiElement: %s: %s\n", e, cause);
        if (cause != null) {
            cause.printStackTrace();
        } else {
            e.printStackTrace();
        }
    }

    static class VSBinding
    extends IDBinding<ResourceLocation> {
        VSBinding() {
        }
    }

    public static class ModelSpec {
        public String modelName;
        public String[] textureNames;
        public Vector3 origin;

        public ModelSpec(String model, String ... textures) {
            this(model, Vector3.zero, textures);
        }

        public ModelSpec(String model, Vector3 origin, String ... textures) {
            this.modelName = model;
            this.textureNames = textures;
            this.origin = origin;
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }

    static interface ISetMod {
        public void setMod(BaseMod var1);
    }

    static interface ITileEntity {
        public void onAddedToWorld();
    }

    static interface IItem
    extends ITextureConsumer {
        public ModelSpec getModelSpec(ItemStack var1);

        public int getNumSubtypes();
    }

    static interface IBlock
    extends ITextureConsumer {
        public void setRenderType(int var1);

        public String getQualifiedRendererClassName();

        public ModelSpec getModelSpec(IBlockState var1);

        public int getNumSubtypes();

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3, Vector3 var4);

        public Class getDefaultItemClass();
    }

    static interface ITextureConsumer {
        public String[] getTextureNames();
    }
}

