/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseMod;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.IProperty;
import gcewing.sg.PropertyInteger;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGBlock;
import gcewing.sg.SGRingTE;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGRingBlock
extends SGBlock<SGRingTE> {
    static final int numSubBlocks = 2;
    public static IProperty<Integer> VARIANT = PropertyInteger.create("variant", 0, 1);
    static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateChevron"};
    static BaseMod.ModelSpec[] models = new BaseMod.ModelSpec[]{new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateRing"), new BaseMod.ModelSpec("block/sg_ring_block.smeg", "stargateBlock", "stargateChevron")};
    static String[] subBlockTitles = new String[]{"Stargate Ring Block", "Stargate Chevron Block"};

    public SGRingBlock() {
        super(Material.field_151576_e, SGRingTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    protected void defineProperties() {
        super.defineProperties();
        this.addProperty(VARIANT);
    }

    @Override
    public int getNumSubtypes() {
        return VARIANT.getAllowedValues().size();
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return models[state.getValue(VARIANT)];
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        if (te.isMerged) {
            IBlockState baseState = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, te.basePos);
            Block block = baseState.getBlock();
            if (block instanceof SGBaseBlock) {
                ((SGBaseBlock)block).onBlockActivated(world, te.basePos, baseState, player, side, cx, cy, cz);
            }
            return true;
        }
        return false;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, BlockPos pos) {
        SGRingTE rte = this.getRingTE(world, pos);
        if (rte != null) {
            return rte.getBaseTE();
        }
        return null;
    }

    public SGRingTE getRingTE(IBlockAccess world, BlockPos pos) {
        TileEntity te = this.getTileEntity(world, pos);
        if (te instanceof SGRingTE) {
            return (SGRingTE)te;
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public boolean isMerged(IBlockAccess world, BlockPos pos) {
        SGRingTE te = this.getRingTE(world, pos);
        return te != null && te.isMerged;
    }

    public void mergeWith(World world, BlockPos pos, BlockPos basePos) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        te.isMerged = true;
        te.basePos = basePos;
        BaseBlockUtils.markWorldBlockForUpdate(world, pos);
    }

    public void unmergeFrom(World world, BlockPos pos, BlockPos basePos) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.unmergeFrom: ring at %s base at %s te.isMerged = %s te.basePos = %s\n", pos, basePos, te.isMerged, te.basePos);
        }
        if (te.isMerged && te.basePos.equals(basePos)) {
            if (SGBaseBlock.debugMerge) {
                System.out.printf("SGRingBlock.unmergeFrom: unmerging\n", new Object[0]);
            }
            te.isMerged = false;
            te.markBlockChanged();
        }
    }

    @Override
    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.onBlockAdded: at %s\n", pos);
        }
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        this.updateBaseBlocks(world, pos, te);
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        SGRingTE te = this.getRingTE((IBlockAccess)world, pos);
        super.breakBlock(world, pos, state);
        if (te != null && te.isMerged) {
            this.updateBaseBlocks(world, pos, te);
        }
    }

    void updateBaseBlocks(World world, BlockPos pos, SGRingTE te) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("SGRingBlock.updateBaseBlocks: merged = %s, base = %s\n", te.isMerged, te.basePos);
        }
        for (int i = -2; i <= 2; ++i) {
            for (int j = -4; j <= 0; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    BlockPos bp = pos.add(i, j, k);
                    Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, bp);
                    if (!(block instanceof SGBaseBlock)) continue;
                    if (SGBaseBlock.debugMerge) {
                        System.out.printf("SGRingBlock.updateBaseBlocks: found base at %s\n", bp);
                    }
                    SGBaseBlock base = (SGBaseBlock)block;
                    if (!te.isMerged) {
                        base.checkForMerge(world, bp);
                        continue;
                    }
                    if (!te.basePos.equals(bp)) continue;
                    base.unmerge(world, bp);
                }
            }
        }
    }
}

