/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGBlock;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import gcewing.sg.SGRingBlock;
import gcewing.sg.SGState;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SGBaseBlock
extends SGBlock<SGBaseTE> {
    static boolean debugMerge = false;
    static int explosionRadius = 10;
    static boolean fieryExplosion = true;
    static boolean smokyExplosion = true;
    static int[][] pattern = new int[][]{{2, 1, 2, 1, 2}, {1, 0, 0, 0, 1}, {2, 0, 0, 0, 2}, {1, 0, 0, 0, 1}, {2, 1, 0, 1, 2}};
    protected static String[] textures = new String[]{"stargateBlock", "stargateRing", "stargateBase_front"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("block/sg_base_block.smeg", textures);

    public static void configure(BaseConfiguration config) {
        explosionRadius = config.getInteger("stargate", "explosionRadius", explosionRadius);
        fieryExplosion = config.getBoolean("stargate", "explosionFlame", fieryExplosion);
        smokyExplosion = config.getBoolean("stargate", "explosionSmoke", smokyExplosion);
    }

    public SGBaseBlock() {
        super(Material.field_151576_e, SGBaseTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public boolean canRenderInLayer(EnumWorldBlockLayer layer) {
        return true;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public SGBaseTE getBaseTE(IBlockAccess world, BlockPos pos) {
        TileEntity te = this.getTileEntity(world, pos);
        if (te instanceof SGBaseTE) {
            return (SGBaseTE)te;
        }
        return null;
    }

    @Override
    protected String getRendererClassName() {
        return "SGRingBlockRenderer";
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean isMerged(IBlockAccess world, BlockPos pos) {
        SGBaseTE te = this.getSGBaseTE(world, pos);
        return te != null && te.isMerged;
    }

    @Override
    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.onBlockAdded: at %s\n", pos);
        }
        this.checkForMerge(world, pos);
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        if (!world.field_72995_K) {
            System.out.printf("SGBaseBlock: at %s meta %s state %s\n", pos, world.func_72805_g(pos.x, pos.y, pos.z), state);
        }
        String Side2 = world.field_72995_K ? "Client" : "Server";
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            if (debugMerge) {
                System.out.printf("SGBaseBlock.onBlockActivated: %s: isMerged = %s\n", Side2, te.isMerged);
            }
            if (te.isMerged) {
                SGCraft.mod.openGui(player, (Enum)SGGui.SGBase, world, pos);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block block) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborBlockChange();
        }
    }

    void checkForMerge(World world, BlockPos pos) {
        if (debugMerge) {
            System.out.printf("SGBaseBlock.checkForMerge at %s\n", pos);
        }
        if (!this.isMerged((IBlockAccess)world, pos)) {
            Trans3 t = this.localToGlobalTransformation((IBlockAccess)world, pos);
            for (int i = -2; i <= 2; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    if (i == 0 && j == 0) continue;
                    BlockPos rp = t.p(i, j, 0.0).blockPos();
                    int type = this.getRingBlockType(world, rp);
                    int pat = pattern[4 - j][2 + i];
                    if (pat == 0 || type == pat) continue;
                    if (debugMerge) {
                        System.out.printf("SGBaseBlock: world %d != pattern %d at %s\n", type, pattern[j][2 + i], rp);
                    }
                    return;
                }
            }
            if (debugMerge) {
                System.out.printf("SGBaseBlock: Merging\n", new Object[0]);
            }
            SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
            te.setMerged(true);
            BaseBlockUtils.markWorldBlockForUpdate(world, pos);
            for (int i = -2; i <= 2; ++i) {
                for (int j = 0; j <= 4; ++j) {
                    BlockPos rp;
                    Block block;
                    if (i == 0 && j == 0 || !((block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, rp = t.p(i, j, 0.0).blockPos())) instanceof SGRingBlock)) continue;
                    ((SGRingBlock)block).mergeWith(world, rp, pos);
                }
            }
            te.checkForLink();
        }
    }

    int getRingBlockType(World world, BlockPos pos) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, pos);
        if (block == Blocks.field_150350_a) {
            return 0;
        }
        if (block == SGCraft.sgRingBlock && !SGCraft.sgRingBlock.isMerged((IBlockAccess)world, pos)) {
            IBlockState state = BaseBlockUtils.getWorldBlockState((IBlockAccess)world, pos);
            switch (state.getValue(SGRingBlock.VARIANT)) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        }
        return -1;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        this.unmerge(world, pos);
        this.dropUpgrades(world, pos);
        super.breakBlock(world, pos, state);
    }

    void dropUpgrades(World world, BlockPos pos) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        if (te != null) {
            if (te.hasChevronUpgrade) {
                this.spawnAsEntity(world, pos, new ItemStack(SGCraft.sgChevronUpgrade));
            }
            if (te.hasIrisUpgrade) {
                this.spawnAsEntity(world, pos, new ItemStack(SGCraft.sgIrisUpgrade));
            }
        }
    }

    public void unmerge(World world, BlockPos pos) {
        SGBaseTE te = this.getSGBaseTE((IBlockAccess)world, pos);
        boolean goBang = false;
        if (te != null) {
            if (te.isMerged && te.state == SGState.Connected) {
                te.state = SGState.Idle;
                goBang = true;
            }
            te.disconnect();
            te.unlinkFromController();
            te.setMerged(false);
            BaseBlockUtils.markWorldBlockForUpdate(world, pos);
            this.unmergeRing(world, pos);
        }
        if (goBang && explosionRadius > 0) {
            this.explode(world, new Vector3(pos).add(0.5, 2.5, 0.5), explosionRadius);
        }
    }

    void explode(World world, Vector3 p, double s) {
        world.func_72885_a(null, p.x, p.y, p.z, (float)s, fieryExplosion, smokyExplosion);
    }

    void unmergeRing(World world, BlockPos pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    this.unmergeRingBlock(world, pos, pos.add(i, j, k));
                }
            }
        }
    }

    void unmergeRingBlock(World world, BlockPos pos, BlockPos ringPos) {
        Block block = BaseBlockUtils.getWorldBlock((IBlockAccess)world, ringPos);
        if (debugMerge) {
            System.out.printf("SGBaseBlock.unmergeRingBlock: found %s at %s\n", block, ringPos);
        }
        if (block instanceof SGRingBlock) {
            ((SGRingBlock)block).unmergeFrom(world, ringPos, pos);
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public int getStrongPower(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.getWeakPower(world, pos, state, side);
    }

    @Override
    public int getWeakPower(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        SGBaseTE te = this.getSGBaseTE(world, pos);
        return te != null && te.state != SGState.Idle ? 15 : 0;
    }
}

