/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseBlock;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseOrientation;
import gcewing.sg.BlockPos;
import gcewing.sg.DHDTE;
import gcewing.sg.IBlockState;
import gcewing.sg.SGBaseBlock;
import gcewing.sg.SGBaseTE;
import gcewing.sg.SGCraft;
import gcewing.sg.SGGui;
import gcewing.sg.Vector3;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DHDBlock
extends BaseBlock<DHDTE> {
    protected static String[] textures = new String[]{"dhd_top", "dhd_side", "stargateBlock", "dhd_button_dim"};
    protected static BaseMod.ModelSpec model = new BaseMod.ModelSpec("dhd.smeg", new Vector3(0.0, -0.5, 0.0), textures);

    public DHDBlock() {
        super(Material.field_151576_e, DHDTE.class);
        this.func_149711_c(1.5f);
        this.func_149647_a(CreativeTabs.field_78026_f);
    }

    @Override
    public String[] getTextureNames() {
        return textures;
    }

    @Override
    public BaseMod.ModelSpec getModelSpec(IBlockState state) {
        return model;
    }

    @Override
    public BaseBlock.IOrientationHandler getOrientationHandler() {
        return BaseOrientation.orient4WaysByState;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        if (SGBaseBlock.debugMerge) {
            System.out.printf("DHDBlock.onBlockAdded: at %s\n", pos);
        }
        this.checkForLink(world, pos);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, player, stack);
        this.checkForLink(world, pos);
    }

    @Override
    public boolean canHarvestBlock(IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        SGBaseTE gte;
        TileEntity cte = this.getTileEntity((IBlockAccess)world, pos);
        super.breakBlock(world, pos, state);
        if (cte == null) {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %s\n", pos);
        } else if (cte instanceof DHDTE && ((DHDTE)cte).isLinkedToStargate && (gte = ((DHDTE)cte).getLinkedStargateTE()) != null) {
            gte.clearLinkToController();
        }
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float cx, float cy, float cz) {
        SGGui id = (double)cy > 0.5 ? SGGui.SGController : SGGui.DHDFuel;
        SGCraft.mod.openGui(player, (Enum)id, world, pos);
        return true;
    }

    public void checkForLink(World world, BlockPos pos) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, pos);
        if (te instanceof DHDTE) {
            ((DHDTE)te).checkForLink();
        } else {
            System.out.printf("DHDBlock.breakBlock: No tile entity at %d\n", pos);
        }
    }
}

