/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseModClient;
import gcewing.sg.BlockPos;
import gcewing.sg.EnumWorldBlockLayer;
import gcewing.sg.IBlockState;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BaseModelRenderer
implements BaseModClient.ICustomRenderer {
    public static boolean debugRenderModel = false;
    protected BaseModClient.IModel model;
    protected BaseModClient.ITexture[] textures;
    protected Vector3 origin;

    public BaseModelRenderer(BaseModClient.IModel model, BaseModClient.ITexture ... textures) {
        this(model, Vector3.zero, textures);
    }

    public BaseModelRenderer(BaseModClient.IModel model, Vector3 origin, BaseModClient.ITexture ... textures) {
        this.model = model;
        this.textures = textures;
        this.origin = origin;
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        BaseMod.IBlock block = (BaseMod.IBlock)state.getBlock();
        Trans3 t2 = t.t(block.localToGlobalTransformation(world, pos, state, Vector3.zero)).translate(this.origin);
        this.model.render(t2, target, this.textures);
    }

    @Override
    public void renderItemStack(ItemStack stack, BaseModClient.IRenderTarget target, Trans3 t) {
        if (debugRenderModel) {
            System.out.printf("BaseModelRenderer.renderItemStack: %s\n", stack);
            System.out.printf("BaseModelRenderer.renderItemStack: model = %s\n", this.model);
            for (int i = 0; i < this.textures.length; ++i) {
                System.out.printf("BaseModelRenderer.renderItemStack: textures[%s] = %s\n", i, this.textures[i]);
            }
        }
        this.model.render(t.translate(this.origin), target, this.textures);
    }
}

