/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraftforge.fluids.IFluidHandler;

public class TransferType {
    private static BiMap<Integer, String[]> typeToInterfaceMap = HashBiMap.create();
    public static final int MATTER_ITEM = 0;
    public static final int MATTER_FLUID = 1;
    public static final int MATTER_ESSENTIA = 2;
    public static final int ENERGY_IC2 = 10;
    public static final int ENERGY_RF = 12;
    public static final int NETWORK_AE = 20;
    public static final int REDSTONE = 21;

    public static void registerType(int type, Class ... classes) {
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        TransferType.registerType(type, names);
    }

    public static void registerType(int type, String ... classes) {
        typeToInterfaceMap.put((Object)type, (Object)classes);
    }

    public static int getTypeForInterface(Class cls) {
        for (Map.Entry entry : typeToInterfaceMap.inverse().entrySet()) {
            for (String clz : (String[])entry.getKey()) {
                if (!cls.getName().equals(clz)) continue;
                return (Integer)entry.getValue();
            }
        }
        return -1;
    }

    static {
        TransferType.registerType(0, IInventory.class, ISidedInventory.class);
        TransferType.registerType(1, IFluidHandler.class);
        TransferType.registerType(2, "thaumcraft.api.aspects.IAspectContainer", "thaumcraft.api.aspects.IAspectSource", "thaumcraft.api.aspects.IEssentiaTransport");
        TransferType.registerType(10, "ic2.api.energy.tile.IEnergyTile", "ic2.api.energy.tile.IEnergySource", "ic2.api.energy.tile.IEnergyEmitter", "ic2.api.energy.tile.IEnergySink", "ic2.api.energy.tile.IEnergyAcceptor", "ic2.api.tile.IEnergyStorage");
        TransferType.registerType(12, "cofh.api.energy.IEnergyHandler");
        TransferType.registerType(20, "appeng.api.networking.IGridHost", "appeng.api.networking.IGridBlock");
    }
}

