/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tile;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import remoteio.common.core.helper.PlayerHelper;
import remoteio.common.core.helper.mod.IC2Helper;
import remoteio.common.core.helper.transfer.IC2TransferHelper;
import remoteio.common.core.helper.transfer.RFTransferHelper;
import remoteio.common.inventory.wrapper.InventoryArray;
import remoteio.common.item.ItemWirelessTransmitter;
import remoteio.common.lib.VisualState;
import remoteio.common.tile.core.TileIOCore;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyEmitter", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyAcceptor", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2"), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI")})
public class TileRemoteInventory
extends TileIOCore
implements IInventory,
IEnergySource,
IEnergySink,
IEnergyHandler {
    public String target;
    private boolean hasPlayer = false;
    private boolean registeredWithIC2 = false;
    private boolean missingUpgrade = false;

    @Override
    public void callback(IInventory inventory) {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.registeredWithIC2) {
            IC2Helper.unloadEnergyTile(this);
            this.registeredWithIC2 = false;
        }
        if (this.hasTransferChip(10) && this.getPlayer() != null) {
            IC2Helper.loadEnergyTile(this);
            this.registeredWithIC2 = true;
        }
        this.missingUpgrade = false;
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.target != null && !this.target.isEmpty()) {
            nbt.func_74778_a("target", this.target);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.target = nbt.func_74764_b("target") ? nbt.func_74779_i("target") : "";
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            boolean hasPlayer;
            EntityPlayer player = this.getPlayer();
            boolean bl = hasPlayer = player != null;
            if (hasPlayer != this.hasPlayer) {
                this.markForUpdate();
                this.updateVisualState();
                this.updateNeighbors();
                this.hasPlayer = hasPlayer;
            }
        }
    }

    public void onChunkUnload() {
        IC2Helper.unloadEnergyTile(this);
    }

    public void func_145843_s() {
        IC2Helper.unloadEnergyTile(this);
    }

    public EntityPlayer getPlayer() {
        if (this.target == null || this.target.isEmpty()) {
            return null;
        }
        EntityPlayerMP player = PlayerHelper.getPlayerForUsername(this.target);
        if (player != null && !ItemWirelessTransmitter.hasValidRemote((EntityPlayer)player)) {
            return null;
        }
        return player;
    }

    public IInventory getPlayerInventory(int transferType) {
        EntityPlayer player = this.getPlayer();
        if (player != null && this.hasTransferChip(transferType)) {
            return new InventoryArray(player.field_71071_by.field_70462_a);
        }
        return null;
    }

    public void setPlayer(String target) {
        if (this.registeredWithIC2) {
            IC2Helper.unloadEnergyTile(this);
            this.registeredWithIC2 = false;
        }
        this.target = target;
        if (!this.registeredWithIC2 && this.hasTransferChip(10)) {
            IC2Helper.loadEnergyTile(this);
            this.registeredWithIC2 = true;
        }
        this.updateVisualState();
        this.updateNeighbors();
        this.markForUpdate();
    }

    @Override
    public VisualState calculateVisualState() {
        if (this.target == null || this.target.isEmpty()) {
            return VisualState.INACTIVE;
        }
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return VisualState.INACTIVE_BLINK;
        }
        if (this.hasUpgradeChip(2)) {
            return VisualState.CAMOUFLAGE_SIMPLE;
        }
        return this.missingUpgrade ? VisualState.ACTIVE_BLINK : VisualState.ACTIVE;
    }

    public int func_70302_i_() {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70298_a(slot, amount) : null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70304_b(slot) : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        if (inventoryPlayer != null) {
            inventoryPlayer.func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null && inventoryPlayer.func_94041_b(slot, stack);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        IInventory inventory = this.getPlayerInventory(10);
        return inventory != null ? (double)IC2TransferHelper.getCharge(inventory) : 0.0;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        IInventory inventory = this.getPlayerInventory(10);
        if (inventory != null) {
            IC2TransferHelper.drain(inventory, amount);
        }
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return Integer.MAX_VALUE;
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        IInventory IInventory2 = this.getPlayerInventory(10);
        return IInventory2 != null ? (IC2TransferHelper.requiresCharge(IInventory2) ? 32.0 : 0.0) : 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        IInventory IInventory2 = this.getPlayerInventory(10);
        return IInventory2 != null ? IC2TransferHelper.fill(IInventory2, amount) : 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getPlayerInventory(10) != null;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IInventory inventory = this.getPlayerInventory(12);
        return inventory != null ? RFTransferHelper.fill(inventory, maxReceive, simulate) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IInventory inventory = this.getPlayerInventory(12);
        return inventory != null ? RFTransferHelper.drain(inventory, maxExtract, simulate) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ForgeDirection from) {
        IInventory inventory = this.getPlayerInventory(12);
        return inventory != null ? RFTransferHelper.getCharge(inventory) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ForgeDirection from) {
        IInventory inventory = this.getPlayerInventory(12);
        return inventory != null ? RFTransferHelper.getMaxCharge(inventory) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getPlayerInventory(12) != null;
    }
}

