/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tile;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import remoteio.common.core.TransferType;
import remoteio.common.core.compat.LinkedGridNode;
import remoteio.common.core.helper.RotationHelper;
import remoteio.common.core.helper.mod.IC2Helper;
import remoteio.common.lib.DimensionalCoords;
import remoteio.common.lib.ModItems;
import remoteio.common.lib.VisualState;
import remoteio.common.tile.core.TileIOCore;
import remoteio.common.tracker.BlockTracker;
import remoteio.common.tracker.RedstoneTracker;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.wands.IWandable;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.aspects.IAspectContainer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.aspects.IAspectSource", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.aspects.IEssentiaTransport", modid="Thaumcraft"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyEmitter", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyAcceptor", modid="IC2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2"), @Optional.Interface(iface="ic2.api.tile.IEnergyStorage", modid="IC2"), @Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI"), @Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.IGridBlock", modid="appliedenergistics2"), @Optional.Interface(iface="thaumcraft.api.wands.IWandable", modid="Thaumcraft"), @Optional.Interface(iface="ic2.api.tile.IWrenchable", modid="IC2")})
public class TileRemoteInterface
extends TileIOCore
implements BlockTracker.ITrackerCallback,
IInventory,
ISidedInventory,
IFluidHandler,
IAspectSource,
IEssentiaTransport,
IEnergySource,
IEnergySink,
IEnergyStorage,
IEnergyHandler,
IGridHost,
IGridBlock,
IWandable,
IWrenchable {
    public DimensionalCoords remotePosition;
    private LinkedGridNode aeGridNode;
    public int rotationY = 0;
    public boolean locked = false;
    private int lastRedstoneLevel = 0;
    private boolean registeredWithIC2 = false;
    private boolean trackingRedstone = false;
    private boolean missingUpgrade = false;
    private boolean tracking = false;

    @Override
    public void callback(IBlockAccess world, int x, int y, int z) {
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void callback(IInventory inventory) {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.registeredWithIC2) {
            IC2Helper.unloadEnergyTile(this);
            this.registeredWithIC2 = false;
        }
        if (this.hasTransferChip(10) && this.remotePosition != null && this.remotePosition.getTileEntity() != null) {
            IC2Helper.loadEnergyTile(this);
            this.registeredWithIC2 = true;
        }
        if (this.trackingRedstone) {
            RedstoneTracker.unregister(this);
            this.trackingRedstone = false;
        }
        RedstoneTracker.register(this);
        this.missingUpgrade = false;
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.remotePosition != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.remotePosition.writeToNBT(tag);
            nbt.func_74782_a("position", (NBTBase)tag);
        }
        nbt.func_74768_a("axisY", this.rotationY);
        nbt.func_74757_a("locked", this.locked);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("position")) {
            this.remotePosition = DimensionalCoords.fromNBT(nbt.func_74775_l("position"));
        } else {
            this.tracking = true;
        }
        this.rotationY = nbt.func_74762_e("axisY");
        this.locked = nbt.func_74767_n("locked");
    }

    @Override
    public void onClientUpdate(NBTTagCompound nbt) {
        super.onClientUpdate(nbt);
        if (nbt.func_74764_b("position")) {
            this.remotePosition = DimensionalCoords.fromNBT(nbt.func_74775_l("position"));
        } else if (nbt.func_74764_b("position_null")) {
            this.remotePosition = null;
        }
        if (nbt.func_74764_b("axisY")) {
            this.rotationY = nbt.func_74762_e("axisY");
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int redstone;
            if (!this.tracking) {
                if (Loader.isModLoaded((String)"appliedenergistics2")) {
                    if (this.remotePosition != null && this.remotePosition.getTileEntity() != this && this.hasTransferChip(20) && this.remotePosition.getTileEntity() instanceof IGridHost) {
                        this.aeGridNode = new LinkedGridNode(((IGridHost)this.remotePosition.getTileEntity()).getGridNode(ForgeDirection.UNKNOWN), this);
                        this.aeGridNode.updateState();
                    }
                    for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                        IGridNode gridNode;
                        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetZ, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
                        if (tileEntity == null || !(tileEntity instanceof IGridHost) || (gridNode = ((IGridHost)tileEntity).getGridNode(forgeDirection.getOpposite())) == null) continue;
                        gridNode.updateState();
                    }
                }
                BlockTracker.INSTANCE.startTracking(this.remotePosition, this);
                this.tracking = true;
            }
            if (!this.trackingRedstone) {
                RedstoneTracker.register(this);
                this.trackingRedstone = true;
            }
            if (this.remotePosition != null && this.hasTransferChip(21) && (redstone = this.field_145850_b.func_94572_D(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != this.lastRedstoneLevel) {
                this.remotePosition.markForUpdate();
                this.lastRedstoneLevel = redstone;
            }
            if (ModAPIManager.INSTANCE.hasAPI("CoFHAPI")) {
                int maxPushPower;
                ItemStack rfTransferChip = null;
                for (int i = 0; i < this.transferChips.func_70302_i_(); ++i) {
                    ItemStack itemStack = this.transferChips.func_70301_a(i);
                    if (itemStack == null || !itemStack.func_77942_o() || itemStack.func_77973_b() != ModItems.transferChip || itemStack.func_77960_j() != 12) continue;
                    rfTransferChip = itemStack;
                    break;
                }
                if (rfTransferChip != null && (maxPushPower = rfTransferChip.func_77978_p().func_74762_e("maxPushRate")) > 0) {
                    int count = 0;
                    IEnergyHandler[] energyHandlers = new IEnergyHandler[ForgeDirection.VALID_DIRECTIONS.length];
                    for (TileEntity forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetX, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
                        if (!(tileEntity instanceof IEnergyHandler) || this.getEnergyStored(forgeDirection.getOpposite()) <= 0) continue;
                        ++count;
                        energyHandlers[forgeDirection.ordinal()] = (IEnergyHandler)tileEntity;
                    }
                    if (count > 0) {
                        int perBlock = maxPushPower / count;
                        for (int i = 0; i < energyHandlers.length; ++i) {
                            IEnergyHandler energyHandler = energyHandlers[i];
                            if (energyHandler == null) continue;
                            ForgeDirection to = ForgeDirection.getOrientation((int)i);
                            ForgeDirection from = to.getOpposite();
                            energyHandler.receiveEnergy(from, this.extractEnergy(to, perBlock, false), false);
                        }
                    }
                }
            }
        }
    }

    public void onChunkUnload() {
        IC2Helper.unloadEnergyTile(this);
        if (Loader.isModLoaded((String)"appliedenergistics2") && this.aeGridNode != null) {
            this.aeGridNode.destroy();
            this.aeGridNode.updateState();
        }
        RedstoneTracker.unregister(this);
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
    }

    public void func_145843_s() {
        IC2Helper.unloadEnergyTile(this);
        if (Loader.isModLoaded((String)"appliedenergistics2") && this.aeGridNode != null) {
            this.aeGridNode.destroy();
            this.aeGridNode.updateState();
        }
        RedstoneTracker.unregister(this);
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void updateRemotePosition() {
        this.sendRemotePosition(this.remotePosition);
    }

    public void sendRemotePosition(DimensionalCoords coords) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (coords != null) {
            NBTTagCompound tag = new NBTTagCompound();
            coords.writeToNBT(tag);
            nbt.func_74782_a("position", (NBTBase)tag);
        } else {
            nbt.func_74757_a("position_null", true);
        }
        this.sendClientUpdate(nbt);
    }

    public void updateRotation(int modification) {
        this.rotationY += modification;
        if (this.rotationY > 3) {
            this.rotationY = 0;
        } else if (this.rotationY < 0) {
            this.rotationY = 3;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("axisY", this.rotationY);
        this.sendClientUpdate(nbt);
    }

    @Override
    public VisualState calculateVisualState() {
        if (this.remotePosition == null) {
            return VisualState.INACTIVE;
        }
        if (!this.remotePosition.blockExists()) {
            return VisualState.INACTIVE_BLINK;
        }
        boolean simple = this.hasUpgradeChip(2);
        boolean remote = this.hasUpgradeChip(0);
        if (simple && !remote) {
            return VisualState.CAMOUFLAGE_SIMPLE;
        }
        if (!simple && remote) {
            return VisualState.CAMOUFLAGE_REMOTE;
        }
        if (simple && remote) {
            return VisualState.CAMOUFLAGE_BOTH;
        }
        return this.missingUpgrade ? VisualState.ACTIVE_BLINK : VisualState.ACTIVE;
    }

    @Override
    public void sendVisualState(VisualState visualState) {
        super.sendVisualState(visualState);
        if (visualState == VisualState.CAMOUFLAGE_REMOTE) {
            this.updateRemotePosition();
        }
    }

    public void setRemotePosition(DimensionalCoords coords) {
        IC2Helper.unloadEnergyTile(this);
        if (Loader.isModLoaded((String)"appliedenergistics2") && this.aeGridNode != null) {
            this.aeGridNode.destroy();
            this.aeGridNode.updateState();
        }
        RedstoneTracker.unregister(this);
        BlockTracker.INSTANCE.stopTracking(this.remotePosition);
        this.remotePosition = coords;
        RedstoneTracker.register(this);
        BlockTracker.INSTANCE.startTracking(this.remotePosition, this);
        IC2Helper.loadEnergyTile(this);
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            if (this.remotePosition != null && this.remotePosition.getTileEntity() != this && this.hasTransferChip(20) && this.remotePosition.getTileEntity() instanceof IGridHost) {
                this.aeGridNode = new LinkedGridNode(((IGridHost)this.remotePosition.getTileEntity()).getGridNode(ForgeDirection.UNKNOWN), this);
                this.aeGridNode.updateState();
            }
            for (ForgeDirection forgeDirection : ForgeDirection.VALID_DIRECTIONS) {
                IGridNode gridNode;
                TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + forgeDirection.offsetZ, this.field_145848_d + forgeDirection.offsetY, this.field_145849_e + forgeDirection.offsetZ);
                if (tileEntity == null || !(tileEntity instanceof IGridHost) || (gridNode = ((IGridHost)tileEntity).getGridNode(forgeDirection.getOpposite())) == null) continue;
                gridNode.updateState();
            }
        }
        this.field_145850_b.func_147460_e(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.markForUpdate();
    }

    public Object getUpgradeImplementation(Class cls) {
        return this.getUpgradeImplementation(cls, -1);
    }

    public Object getUpgradeImplementation(Class cls, int upgradeType) {
        if (this.remotePosition == null) {
            return null;
        }
        if (!this.remotePosition.blockExists()) {
            return null;
        }
        TileEntity remote = this.remotePosition.getTileEntity();
        if (remote != null ? !cls.isInstance(remote) : !cls.isInstance(this.remotePosition.getBlock())) {
            return null;
        }
        if (upgradeType != -1 && !this.hasUpgradeChip(upgradeType)) {
            return null;
        }
        return cls.cast(remote);
    }

    public Object getTransferImplementation(Class cls) {
        return this.getTransferImplementation(cls, true);
    }

    public Object getTransferImplementation(Class cls, boolean requiresChip) {
        if (this.remotePosition == null) {
            return null;
        }
        if (!this.remotePosition.blockExists()) {
            return null;
        }
        TileEntity remote = this.remotePosition.getTileEntity();
        if (remote != null ? !cls.isInstance(remote) : !cls.isInstance(this.remotePosition.getBlock())) {
            return null;
        }
        if (requiresChip && !this.hasTransferChip(TransferType.getTypeForInterface(cls))) {
            if (!this.missingUpgrade) {
                this.missingUpgrade = true;
                this.updateVisualState();
            }
            return null;
        }
        return cls.cast(remote);
    }

    public ForgeDirection getAdjustedSide(ForgeDirection side) {
        return side;
    }

    public int getAdjustedSide(int side) {
        return RotationHelper.getRotatedSide(0, this.rotationY, 0, side);
    }

    public int func_70302_i_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amt) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70298_a(slot, amt) : null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70304_b(slot) : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            inventory.func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_145825_b() : null;
    }

    public boolean func_145818_k_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null && inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null ? inventory.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null && inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null && inventory.func_94041_b(slot, stack);
    }

    public int[] func_94128_d(int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_94128_d(this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            int[] array = new int[inventory.func_70302_i_()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = i;
            }
            return array;
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_102007_a(slot, stack, this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        if (inventory != null) {
            return inventory.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        ISidedInventory sidedInventory = (ISidedInventory)this.getTransferImplementation(ISidedInventory.class);
        if (sidedInventory != null) {
            return sidedInventory.func_102008_b(slot, stack, this.getAdjustedSide(side));
        }
        IInventory inventory = (IInventory)this.getTransferImplementation(IInventory.class);
        return inventory != null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.fill(this.getAdjustedSide(from), resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.drain(this.getAdjustedSide(from), resource, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.drain(this.getAdjustedSide(from), maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null && fluidHandler.canFill(this.getAdjustedSide(from), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null && fluidHandler.canDrain(this.getAdjustedSide(from), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getTransferImplementation(IFluidHandler.class);
        return fluidHandler != null ? fluidHandler.getTankInfo(this.getAdjustedSide(from)) : new FluidTankInfo[]{};
    }

    @Optional.Method(modid="Thaumcraft")
    public AspectList getAspects() {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null ? aspectContainer.getAspects() : new AspectList();
    }

    @Optional.Method(modid="Thaumcraft")
    public void setAspects(AspectList aspects) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        if (aspectContainer != null) {
            aspectContainer.setAspects(aspects);
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerAccept(Aspect tag) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null && aspectContainer.doesContainerAccept(tag);
    }

    @Optional.Method(modid="Thaumcraft")
    public int addToContainer(Aspect tag, int amount) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null ? aspectContainer.addToContainer(tag, amount) : amount;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean takeFromContainer(Aspect tag, int amount) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null && aspectContainer.takeFromContainer(tag, amount);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean takeFromContainer(AspectList ot) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null && aspectContainer.takeFromContainer(ot);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null && aspectContainer.doesContainerContainAmount(tag, amount);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean doesContainerContain(AspectList ot) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null && aspectContainer.doesContainerContain(ot);
    }

    @Optional.Method(modid="Thaumcraft")
    public int containerContains(Aspect tag) {
        IAspectSource aspectContainer = (IAspectSource)this.getTransferImplementation(IAspectSource.class);
        return aspectContainer != null ? aspectContainer.containerContains(tag) : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean isConnectable(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null && essentiaTransport.isConnectable(this.getAdjustedSide(face));
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean canOutputTo(ForgeDirection face) {
        return true;
    }

    @Optional.Method(modid="Thaumcraft")
    public void setSuction(Aspect aspect, int amount) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        if (essentiaTransport != null) {
            essentiaTransport.setSuction(aspect, amount);
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getSuctionType(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getSuctionType(this.getAdjustedSide(face)) : null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getSuctionAmount(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getSuctionAmount(this.getAdjustedSide(face)) : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.takeEssentia(aspect, amount, this.getAdjustedSide(face)) : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.addEssentia(aspect, amount, this.getAdjustedSide(face)) : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public Aspect getEssentiaType(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getEssentiaType(this.getAdjustedSide(face)) : null;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getEssentiaAmount(ForgeDirection face) {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getEssentiaAmount(this.getAdjustedSide(face)) : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public int getMinimumSuction() {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null ? essentiaTransport.getMinimumSuction() : 0;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean renderExtendedTube() {
        IEssentiaTransport essentiaTransport = (IEssentiaTransport)this.getTransferImplementation(IEssentiaTransport.class);
        return essentiaTransport != null && essentiaTransport.renderExtendedTube();
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        return energySource != null ? energySource.getOfferedEnergy() : 0.0;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        if (energySource != null) {
            energySource.drawEnergy(amount);
        }
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        return energySource != null && energySource.emitsEnergyTo(receiver, this.getAdjustedSide(direction));
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.getDemandedEnergy() : 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.getSinkTier() : 0;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        IEnergySink energySink = (IEnergySink)this.getTransferImplementation(IEnergySink.class);
        return energySink != null ? energySink.injectEnergy(this.getAdjustedSide(directionFrom), amount, voltage) : 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        IEnergyAcceptor energyAcceptor = (IEnergyAcceptor)this.getTransferImplementation(IEnergyAcceptor.class);
        return energyAcceptor != null && energyAcceptor.acceptsEnergyFrom(emitter, this.getAdjustedSide(direction));
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        IEnergySource energySource = (IEnergySource)this.getTransferImplementation(IEnergySource.class);
        return energySource != null ? energySource.getSourceTier() : 0;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null ? energyStorage.getStored() : 0;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        if (energyStorage != null) {
            energyStorage.setStored(energy);
        }
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null ? energyStorage.addEnergy(amount) : this.getStored();
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null ? energyStorage.getCapacity() : 0;
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null ? energyStorage.getOutput() : 0;
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null ? energyStorage.getOutputEnergyUnitsPerTick() : 0.0;
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(ForgeDirection side) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.getTransferImplementation(IEnergyStorage.class);
        return energyStorage != null && energyStorage.isTeleporterCompatible(this.getAdjustedSide(side));
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        IEnergyHandler energyHandler = (IEnergyHandler)this.getTransferImplementation(IEnergyHandler.class);
        return energyHandler != null ? energyHandler.receiveEnergy(this.getAdjustedSide(from), maxReceive, simulate) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        IEnergyHandler energyHandler = (IEnergyHandler)this.getTransferImplementation(IEnergyHandler.class);
        return energyHandler != null ? energyHandler.extractEnergy(this.getAdjustedSide(from), maxExtract, simulate) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ForgeDirection from) {
        IEnergyHandler energyHandler = (IEnergyHandler)this.getTransferImplementation(IEnergyHandler.class);
        return energyHandler != null ? energyHandler.getEnergyStored(this.getAdjustedSide(from)) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ForgeDirection from) {
        IEnergyHandler energyHandler = (IEnergyHandler)this.getTransferImplementation(IEnergyHandler.class);
        return energyHandler != null ? energyHandler.getMaxEnergyStored(this.getAdjustedSide(from)) : 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI")
    public boolean canConnectEnergy(ForgeDirection from) {
        IEnergyHandler energyHandler = (IEnergyHandler)this.getTransferImplementation(IEnergyHandler.class);
        return energyHandler != null && energyHandler.canConnectEnergy(this.getAdjustedSide(from));
    }

    @Optional.Method(modid="Thaumcraft")
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        return wandable != null ? wandable.onWandRightClick(world, wandstack, player, x, y, z, this.getAdjustedSide(side), md) : -1;
    }

    @Optional.Method(modid="Thaumcraft")
    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        return wandable != null ? wandable.onWandRightClick(world, wandstack, player) : wandstack;
    }

    @Optional.Method(modid="Thaumcraft")
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        if (wandable != null) {
            wandable.onUsingWandTick(wandstack, player, count);
        }
    }

    @Optional.Method(modid="Thaumcraft")
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
        IWandable wandable = (IWandable)this.getUpgradeImplementation(IWandable.class, 1);
        if (wandable != null) {
            wandable.onWandStoppedUsing(wandstack, world, player, count);
        }
    }

    @Optional.Method(modid="IC2")
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        return wrenchable != null && wrenchable.wrenchCanSetFacing(entityPlayer, this.getAdjustedSide(side));
    }

    @Optional.Method(modid="IC2")
    public short getFacing() {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        return wrenchable != null ? wrenchable.getFacing() : (short)0;
    }

    @Optional.Method(modid="IC2")
    public void setFacing(short facing) {
        IWrenchable wrenchable = (IWrenchable)this.getUpgradeImplementation(IWrenchable.class, 1);
        if (wrenchable != null) {
            wrenchable.setFacing((short)this.getAdjustedSide(facing));
        }
    }

    @Optional.Method(modid="IC2")
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    @Optional.Method(modid="IC2")
    public float getWrenchDropRate() {
        return 0.0f;
    }

    @Optional.Method(modid="IC2")
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection dir) {
        IGridHost gridNode = (IGridHost)this.getTransferImplementation(IGridHost.class);
        return gridNode != null ? gridNode.getGridNode(this.getAdjustedSide(dir)) : null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Optional.Method(modid="appliedenergistics2")
    public double getIdlePowerUsage() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        return gridBlock != null ? gridBlock.getIdlePowerUsage() : 0.0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<GridFlags> getFlags() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        return gridBlock != null ? this.getFlags() : EnumSet.noneOf(GridFlags.class);
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isWorldAccessible() {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Optional.Method(modid="appliedenergistics2")
    public AEColor getGridColor() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        return gridBlock != null ? gridBlock.getGridColor() : AEColor.Transparent;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onGridNotification(GridNotification notification) {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        if (gridBlock != null) {
            gridBlock.onGridNotification(notification);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void setNetworkStatus(IGrid grid, int channelsInUse) {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        if (gridBlock != null) {
            gridBlock.setNetworkStatus(grid, channelsInUse);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<ForgeDirection> getConnectableSides() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        return gridBlock != null ? gridBlock.getConnectableSides() : EnumSet.noneOf(ForgeDirection.class);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridHost getMachine() {
        return this;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        if (gridBlock != null) {
            gridBlock.gridChanged();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public ItemStack getMachineRepresentation() {
        IGridBlock gridBlock = (IGridBlock)this.getTransferImplementation(IGridBlock.class);
        return gridBlock != null ? this.getMachineRepresentation() : new ItemStack(this.field_145854_h);
    }
}

