/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Client;

import java.awt.Color;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    static Gui gui = new Gui();

    public static void fillAreaWithIcon(IIcon icon, int x, int y, int width, int height) {
        int scale = RenderUtils.computeGuiScale();
        GL11.glScissor((int)0, (int)(Minecraft.func_71410_x().field_71440_d - (y + height) * scale), (int)((width + x) * scale), (int)(height * scale));
        GL11.glEnable((int)3089);
        int cols = MathHelper.func_76123_f((float)((float)width / 16.0f));
        int rows = MathHelper.func_76123_f((float)((float)height / 16.0f));
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                gui.func_94065_a(x + col * 16, y + row * 16, icon, 16, 16);
            }
        }
        GL11.glDisable((int)3089);
    }

    public static void drawTexturedModalRect(int p_73729_1_, int p_73729_2_, int p_73729_3_, int p_73729_4_, int p_73729_5_, int p_73729_6_, int zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)p_73729_1_, (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)p_73729_3_ * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)(p_73729_2_ + p_73729_6_), (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)(p_73729_4_ + p_73729_6_) * f1));
        tessellator.func_78374_a((double)(p_73729_1_ + p_73729_5_), (double)p_73729_2_, (double)zLevel, (double)((float)(p_73729_3_ + p_73729_5_) * f), (double)((float)p_73729_4_ * f1));
        tessellator.func_78374_a((double)p_73729_1_, (double)p_73729_2_, (double)zLevel, (double)((float)p_73729_3_ * f), (double)((float)p_73729_4_ * f1));
        tessellator.func_78381_a();
    }

    public static void drawTexturedQuad(int x, int y, int width, int height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static float interpolateRotation(float p_77034_1_, float p_77034_2_, float p_77034_3_) {
        float f3;
        for (f3 = p_77034_2_ - p_77034_1_; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return p_77034_1_ + p_77034_3_ * f3;
    }

    public static Color getAverageIconColor(IIcon icon) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)icon;
        int x = sprite.func_130010_a();
        int y = sprite.func_110967_i();
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        int textureMapID = Minecraft.func_71410_x().func_147117_R().func_110552_b();
        GL11.glBindTexture((int)3553, (int)textureMapID);
        int textureWidth = (int)GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4096);
        int textureHeight = (int)GL11.glGetTexLevelParameterf((int)3553, (int)0, (int)4097);
        IntBuffer ib = BufferUtils.createIntBuffer((int)(textureWidth * textureHeight * 4));
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5125, (IntBuffer)ib);
        GL11.glBindTexture((int)3553, (int)0);
        int startPos = y * width + x;
        ib.rewind();
        for (int i = 0; i < ib.capacity(); ++i) {
            int color = ib.get();
            Color c = new Color(color);
            if (c.getRed() != 105 || c.getGreen() != 105 || c.getBlue() != 106) continue;
            System.out.println("Found at " + i);
        }
        return null;
    }

    public static int computeGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static void drawFluidStack(FluidTankInfo tankInfo, int x, int y, int width, int fullHeight) {
        TextureManager renderEngine = Minecraft.func_71410_x().field_71446_o;
        FluidStack fluidStack = tankInfo.fluid;
        if (fluidStack != null) {
            Fluid fluid = fluidStack.getFluid();
            IIcon fluidIcon = fluid.getStillIcon();
            int fluidHeight = MathHelper.func_76123_f((float)((float)fluidStack.amount / (float)tankInfo.capacity * (float)fullHeight));
            GL11.glDisable((int)3042);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            renderEngine.func_110577_a(renderEngine.func_130087_a(fluid.getSpriteNumber()));
            RenderUtils.fillAreaWithIcon(fluidIcon, x, y + fullHeight - fluidHeight, width, fluidHeight);
        }
    }

    public static void drawCube(float posX, float posY, float posZ, float size) {
        RenderUtils.drawCube(posX, posY, posZ, size, 1.0f, 1.0f, 1.0f, 0.5f);
    }

    public static void drawCube(float posX, float posY, float posZ, float size, float red, float green, float blue, float alpha) {
        Minecraft.func_71410_x().field_71460_t.func_78483_a(0.0);
        Tessellator t = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
        t.func_78382_b();
        t.func_78369_a(red, green, blue, alpha);
        t.func_78377_a(0.0, 0.0, 0.0);
        t.func_78377_a(0.0, (double)size, 0.0);
        t.func_78377_a((double)size, (double)size, 0.0);
        t.func_78377_a((double)size, 0.0, 0.0);
        t.func_78377_a((double)size, (double)size, 0.0);
        t.func_78377_a((double)size, (double)size, (double)size);
        t.func_78377_a((double)size, 0.0, (double)size);
        t.func_78377_a((double)size, 0.0, 0.0);
        t.func_78377_a((double)size, (double)size, (double)size);
        t.func_78377_a(0.0, (double)size, (double)size);
        t.func_78377_a(0.0, 0.0, (double)size);
        t.func_78377_a((double)size, 0.0, (double)size);
        t.func_78377_a(0.0, (double)size, (double)size);
        t.func_78377_a(0.0, (double)size, 0.0);
        t.func_78377_a(0.0, 0.0, 0.0);
        t.func_78377_a(0.0, 0.0, (double)size);
        t.func_78377_a(0.0, 0.0, 0.0);
        t.func_78377_a((double)size, 0.0, 0.0);
        t.func_78377_a((double)size, 0.0, (double)size);
        t.func_78377_a(0.0, 0.0, (double)size);
        t.func_78377_a(0.0, (double)size, 0.0);
        t.func_78377_a(0.0, (double)size, (double)size);
        t.func_78377_a((double)size, (double)size, (double)size);
        t.func_78377_a((double)size, (double)size, 0.0);
        t.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().field_71460_t.func_78463_b(0.0);
    }

    public static void enableDefaultBlending() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }
}

