/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileChestRailcraft
extends TileMachineItem {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final int TICK_PER_SYNC = 64;
    private ForgeDirection facing = ForgeDirection.EAST;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;

    public TileChestRailcraft() {
        super(27);
    }

    public final ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
    }

    @Override
    public final boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public final ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public final boolean openGui(EntityPlayer player) {
        if (this.field_145850_b.isSideSolid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ForgeDirection.DOWN)) {
            return false;
        }
        if (this.isCatOnChest()) {
            return false;
        }
        if (Game.isHost(this.field_145850_b)) {
            player.func_71007_a((IInventory)this);
        }
        return true;
    }

    private boolean isCatOnChest() {
        EntityOcelot entityocelot;
        EntityOcelot cat;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Iterator it = this.field_145850_b.func_72872_a(EntityOcelot.class, AxisAlignedBB.func_72330_a((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1))).iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while (!(cat = (entityocelot = (EntityOcelot)it.next())).func_70906_o());
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.clock % 64 == 0) {
            WorldPlugin.addBlockEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float angleChange = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float openAngle;
            float angle = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angleChange) : (this.lidAngle -= angleChange);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (openAngle = 0.5f) && angle >= openAngle) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numUsingPlayers = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    @Override
    public void func_70295_k_() {
        ++this.numUsingPlayers;
        WorldPlugin.addBlockEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
    }

    @Override
    public void func_70305_f() {
        --this.numUsingPlayers;
        WorldPlugin.addBlockEvent(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        data.func_74774_a("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
    }
}

