/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.common.blocks.machine.BoundingBoxManager;
import mods.railcraft.common.blocks.machine.IComparatorOverride;
import mods.railcraft.common.blocks.machine.IComparatorValueProvider;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.IMachineProxy;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public class BlockMachine
extends BlockContainer
implements IPostConnection {
    private final IMachineProxy proxy;
    private final int renderId;
    private final int[] metaOpacity;

    public BlockMachine(int renderId, IMachineProxy proxy, boolean opaque, int[] metaOpacity) {
        super(Material.field_151576_e);
        this.func_149752_b(4.5f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149769_e);
        this.func_149675_a(true);
        this.proxy = proxy;
        this.field_149787_q = opaque;
        this.renderId = renderId;
        this.metaOpacity = metaOpacity;
        this.func_149647_a(CreativePlugin.RAILCRAFT_TAB);
        this.field_149786_r = opaque ? 255 : 0;
    }

    public int func_149645_b() {
        return this.renderId;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_149685_I() {
        return 1.0f;
    }

    public IMachineProxy getMachineProxy() {
        return this.proxy;
    }

    public IEnumMachine getMachineType(World world, int x, int y, int z) {
        int meta = WorldPlugin.getBlockMetadata((IBlockAccess)world, x, y, z);
        return this.proxy.getMachine(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.proxy.registerIcons(iconRegister);
    }

    public IIcon func_149673_e(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getIcon(side);
        }
        int meta = world.func_72805_g(i, j, k);
        return this.func_149691_a(side, meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.proxy.getMachine(meta).getTexture(side);
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).colorMultiplier();
        }
        return super.func_149720_d(world, x, y, z);
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).recolourBlock(colour);
        }
        return false;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).blockActivated(player, side);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random random) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).randomDisplayTick(random);
        }
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).isSideSolid(side);
        }
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        player.func_71064_a(StatList.field_75934_C[BlockMachine.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (willHarvest && !player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, 0, 0);
        }
        super.removedByPlayer(world, player, x, y, z, willHarvest);
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getDrops(fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public ArrayList<ItemStack> getBlockDroppedSilkTouch(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getBlockDroppedSilkTouch(fortune);
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).canSilkHarvest(player);
        }
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ArrayList<ItemStack> drops = this.getBlockDroppedSilkTouch(world, x, y, z, 0, 0);
        return (ItemStack)drops.get(0);
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).isPoweringTo(side) ? 15 : 0;
        }
        return 0;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public void initFromItem(World world, int i, int j, int k, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).initFromItem(stack);
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockPlacedBy(entityliving, stack);
        }
    }

    public void func_149695_a(World world, int i, int j, int k, Block block) {
        block3: {
            try {
                TileEntity tile = world.func_147438_o(i, j, k);
                if (tile instanceof TileMachineBase) {
                    ((TileMachineBase)tile).onNeighborBlockChange(block);
                }
            }
            catch (StackOverflowError error) {
                Game.logThrowable(Level.ERROR, "Stack Overflow Error in BlockMachine.onNeighborBlockChange()", 10, error, new Object[0]);
                if (!Game.IS_DEBUG) break block3;
                throw error;
            }
        }
    }

    public void func_149726_b(World world, int i, int j, int k) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockAdded();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            ((TileMachineBase)tile).onBlockRemoval();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.proxy.getMachine(meta).getTileEntity();
    }

    public TileEntity func_149915_a(World var1, int meta) {
        return null;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getLightValue();
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (IEnumMachine iEnumMachine : this.proxy.getCreativeList()) {
            if (!iEnumMachine.isAvaliable()) continue;
            list.add(iEnumMachine.getItem());
        }
    }

    public final boolean func_149662_c() {
        return this.field_149787_q;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 0 && meta < this.metaOpacity.length) {
            return this.metaOpacity[meta];
        }
        return 255;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double srcX, double srcY, double srcZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getResistance(exploder) * 3.0f / 5.0f;
        }
        return super.getExplosionResistance(exploder, world, x, y, z, this.field_149759_B, this.field_149760_C, this.field_149754_D);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        if (RailcraftConfig.cannotMobsSpawnOnMechanism) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).canCreatureSpawn(type);
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).getHardness();
        }
        return super.func_149712_f(world, x, y, z);
    }

    public boolean func_149740_M() {
        return this.proxy instanceof IComparatorOverride;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IComparatorValueProvider) {
            return ((IComparatorValueProvider)tile).getComparatorInputOverride(world, x, y, z, side);
        }
        return 0;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileMachineBase) {
            return ((TileMachineBase)tile).connectsToPost(side);
        }
        return IPostConnection.ConnectStyle.NONE;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return BoundingBoxManager.getCollisionBox(world, x, y, z, this.getMachineType(world, x, y, z));
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return BoundingBoxManager.getSelectionBox(world, x, y, z, this.getMachineType(world, x, y, z));
    }
}

