/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.Random;
import mods.railcraft.client.render.IInvRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderer
implements IItemRenderer {
    private IInvRenderer renderer;
    private final Random rand = new Random();

    public ItemRenderer(IInvRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case EQUIPPED_BLOCK: 
            case BLOCK_3D: 
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: 
            case INVENTORY_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                this.renderer.renderItem((RenderBlocks)data[0], item, type);
                break;
            }
            case INVENTORY: {
                this.renderer.renderItem((RenderBlocks)data[0], item, type);
                break;
            }
            case ENTITY: {
                this.renderEntity((RenderBlocks)data[0], (EntityItem)data[1]);
            }
        }
    }

    protected void renderEntity(RenderBlocks render, EntityItem item) {
        this.rand.setSeed(187L);
        int num = 1;
        ItemStack stack = item.func_92059_d();
        if (stack.field_77994_a > 1) {
            num = 2;
        }
        if (stack.field_77994_a > 5) {
            num = 3;
        }
        if (stack.field_77994_a > 20) {
            num = 4;
        }
        if (render.field_147844_c) {
            int color = stack.func_77973_b().func_82790_a(stack, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        }
        this.renderer.renderItem(render, stack, IItemRenderer.ItemRenderType.ENTITY);
    }
}

