/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui;

import mods.railcraft.client.gui.GuiTools;
import mods.railcraft.client.gui.TileGui;
import mods.railcraft.client.gui.buttons.GuiMultiButton;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.tracks.TrackRouting;
import mods.railcraft.common.gui.buttons.LockButtonState;
import mods.railcraft.common.gui.containers.ContainerTrackRouting;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.StatCollector;

public class GuiTrackRouting
extends TileGui {
    private GuiMultiButton lockButton;
    private final EntityPlayer player;
    private final TrackRouting track;
    private ToolTip lockedToolTips;
    private ToolTip unlockedToolTips;
    private ToolTip notownedToolTips;
    private String ownerName = "[Unknown]";

    public GuiTrackRouting(InventoryPlayer inv, TrackRouting track) {
        super((RailcraftTileEntity)track.getTile(), new ContainerTrackRouting(inv, track), "railcraft:textures/gui/gui_track_routing.png");
        this.field_147000_g = 140;
        this.track = track;
        this.player = inv.field_70458_d;
        this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + this.ownerName);
        this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + this.ownerName);
        this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + this.ownerName);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.track == null) {
            return;
        }
        this.field_146292_n.clear();
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.lockButton = new GuiMultiButton(8, w + 152, h + 8, 16, this.track.getLockController());
        this.field_146292_n.add(this.lockButton);
        this.lockButton.field_146124_l = ((ContainerTrackRouting)this.container).canLock;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (this.track == null) {
            return;
        }
        this.updateButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
    }

    private void updateButtons() {
        this.lockButton.field_146124_l = ((ContainerTrackRouting)this.container).canLock;
        String username = ((ContainerTrackRouting)this.container).ownerName;
        if (username != null && !username.equals(this.ownerName)) {
            this.ownerName = username;
            this.lockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.locked", "{owner}=" + username);
            this.unlockedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.unlocked", "{owner}=" + username);
            this.notownedToolTips = ToolTip.buildToolTip("railcraft.gui.tip.button.lock.notowner", "{owner}=" + username);
        }
        this.lockButton.setToolTip(this.track.getLockController().getButtonState() == LockButtonState.LOCKED ? this.lockedToolTips : (this.lockButton.field_146124_l ? this.unlockedToolTips : this.notownedToolTips));
    }

    public void func_146281_b() {
        this.sendUpdatePacket();
    }

    private void sendUpdatePacket() {
        PacketBuilder.instance().sendGuiReturnPacket((IGuiReturnHandler)this.track.getTile());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GuiTools.drawCenteredString(this.field_146289_q, this.track.getName(), 6);
        this.field_146289_q.func_78276_b(LocalizationPlugin.translate("railcraft.gui.routing.track.slot.label"), 64, 29, 0x404040);
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
    }
}

