/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SimpleSignalController
extends SignalController {
    @Nonnull
    private SignalAspect aspect = SignalAspect.BLINK_RED;
    private boolean needsInit = true;

    public SimpleSignalController(String locTag, TileEntity tile) {
        super(locTag, tile, 1);
    }

    @Nonnull
    public SignalAspect getAspect() {
        return this.aspect;
    }

    public void setAspect(@Nonnull SignalAspect aspect) {
        if (this.aspect != aspect) {
            this.aspect = aspect;
            this.updateReceiver();
        }
    }

    @Override
    @Nonnull
    public SignalAspect getAspectFor(WorldCoordinate receiver) {
        return this.aspect;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.needsInit) {
            this.needsInit = false;
            this.updateReceiver();
        }
    }

    private void updateReceiver() {
        for (WorldCoordinate recv : this.getPairs()) {
            SignalReceiver receiver = this.getReceiverAt(recv);
            if (receiver == null) continue;
            receiver.onControllerAspectChange(this, this.aspect);
        }
    }

    @Override
    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        data.func_74774_a("aspect", (byte)this.aspect.ordinal());
    }

    @Override
    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        this.aspect = SignalAspect.fromOrdinal(data.func_74771_c("aspect"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.aspect.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.aspect = SignalAspect.fromOrdinal(data.readByte());
    }

    public String toString() {
        return String.format("Controller:%s (%s)", new Object[]{this.aspect, super.toString()});
    }
}

